/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.ReflogCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.InvalidRefNameException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ReflogEntry;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;

public class StashListCommand
extends GitCommand<Collection<RevCommit>> {
    public StashListCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<RevCommit> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            if (this.repo.exactRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
        ReflogCommand refLog = new ReflogCommand(this.repo);
        refLog.setRef("refs/stash");
        Object stashEntries = refLog.call();
        if (stashEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> stashCommits = new ArrayList<RevCommit>(stashEntries.size());
        try (RevWalk walk = new RevWalk(this.repo);){
            Iterator iterator = stashEntries.iterator();
            while (iterator.hasNext()) {
                ReflogEntry entry = (ReflogEntry)iterator.next();
                try {
                    stashCommits.add(walk.parseCommit(entry.getNewId()));
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, entry.getNewId()), e);
                    return stashCommits;
                }
            }
        }
    }
}

