/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.generated.sarif.Artifact;
import se.bjurr.violations.lib.model.generated.sarif.Location;
import se.bjurr.violations.lib.model.generated.sarif.Message;
import se.bjurr.violations.lib.model.generated.sarif.PhysicalLocation;
import se.bjurr.violations.lib.model.generated.sarif.Region;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptor;
import se.bjurr.violations.lib.model.generated.sarif.Result;
import se.bjurr.violations.lib.model.generated.sarif.Run;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.violationslib.com.google.gson.GsonBuilder;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializationContext;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializer;
import se.bjurr.violations.violationslib.com.google.gson.JsonElement;
import se.bjurr.violations.violationslib.com.google.gson.JsonParseException;

public class SarifParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        SarifSchema report = new GsonBuilder().registerTypeAdapter((Type)((Object)Result.Level.class), new ResultDeserializer()).create().fromJson(reportContent, SarifSchema.class);
        TreeSet<Violation> violations = new TreeSet<Violation>();
        if (report.getRuns() == null) {
            return violations;
        }
        for (Run run : report.getRuns()) {
            String reporter = "Sarif";
            if (run.getTool() != null && run.getTool().getDriver() != null && run.getTool().getDriver().getName() != null && !run.getTool().getDriver().getName().trim().isEmpty()) {
                reporter = run.getTool().getDriver().getName();
            }
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(run.getArtifacts());
            Map<String, String> helpMap = this.extractHelpText(run);
            for (Result result : run.getResults()) {
                String ruleId = result.getRuleId();
                String message = this.extractMessage(result.getMessage());
                if (Utils.isNullOrEmpty(message)) continue;
                Result.Level level = result.getLevel();
                for (Location location : result.getLocations()) {
                    Integer startLine;
                    PhysicalLocation physicalLocation = location.getPhysicalLocation();
                    Region region = physicalLocation.getRegion();
                    if (region == null || (startLine = region.getStartLine()) == null) continue;
                    String filename = null;
                    Integer artifactLocationIndex = physicalLocation.getArtifactLocation().getIndex();
                    filename = artifactLocationIndex != null && artifactLocationIndex != -1 ? ((Artifact)artifacts.get(artifactLocationIndex)).getLocation().getUri() : physicalLocation.getArtifactLocation().getUri();
                    String regionMessage = this.extractMessage(region.getMessage());
                    StringBuilder fullMessage = new StringBuilder(message);
                    if (regionMessage != null) {
                        fullMessage.append("\n\n").append(regionMessage);
                    }
                    if (helpMap.containsKey(ruleId)) {
                        fullMessage.append("\n\nFor additional help see: ").append(helpMap.get(ruleId));
                    }
                    violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile(filename).setStartLine(startLine).setRule(ruleId).setMessage(fullMessage.toString().trim()).setSeverity(this.toSeverity(level)).setReporter(reporter).build());
                }
            }
        }
        return violations;
    }

    protected String extractMessage(Message message) {
        if (message == null) {
            return null;
        }
        String text = message.getMarkdown();
        if (Utils.isNullOrEmpty(text)) {
            text = message.getText();
        }
        return text;
    }

    private Map<String, String> extractHelpText(Run run) {
        HashMap<String, String> helpMap = new HashMap<String, String>();
        if (run.getTool() != null && run.getTool().getDriver() != null && run.getTool().getDriver().getRules() != null) {
            for (ReportingDescriptor r : run.getTool().getDriver().getRules()) {
                if (r.getHelp() == null) continue;
                if (r.getHelp().getMarkdown() != null && !r.getHelp().getMarkdown().trim().isEmpty()) {
                    helpMap.put(r.getId(), r.getHelp().getMarkdown());
                    continue;
                }
                if (r.getHelp().getMarkdown() == null || r.getHelp().getText().trim().isEmpty()) continue;
                helpMap.put(r.getId(), r.getHelp().getText());
            }
        }
        return helpMap;
    }

    private SEVERITY toSeverity(Result.Level level) {
        if (level == Result.Level.ERROR) {
            return SEVERITY.ERROR;
        }
        if (level == Result.Level.WARNING) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private static class ResultDeserializer
    implements JsonDeserializer<Result.Level> {
        private ResultDeserializer() {
        }

        @Override
        public Result.Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String asString = json.getAsString();
                return Result.Level.fromValue(asString);
            }
            catch (Exception e) {
                return Result.Level.NONE;
            }
        }
    }
}

