/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model.sarif;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.generated.sarif.ArtifactLocation;
import se.bjurr.violations.lib.model.generated.sarif.Location;
import se.bjurr.violations.lib.model.generated.sarif.Message;
import se.bjurr.violations.lib.model.generated.sarif.PhysicalLocation;
import se.bjurr.violations.lib.model.generated.sarif.Region;
import se.bjurr.violations.lib.model.generated.sarif.Result;
import se.bjurr.violations.lib.model.generated.sarif.Run;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;

public class SarifTransformer {
    public static SarifSchema fromViolations(Set<Violation> from) {
        List<Result> results = SarifTransformer.toResults(from);
        Run run = new Run();
        run.withResults(results);
        ArrayList<Run> runs = new ArrayList<Run>();
        runs.add(run);
        return new SarifSchema().withRuns(runs);
    }

    private static List<Result> toResults(Set<Violation> from) {
        return from.stream().map(it -> SarifTransformer.transform(it)).collect(Collectors.toList());
    }

    private static Result transform(Violation from) {
        Result.Level level = SarifTransformer.toLevel(from.getSeverity());
        Region region = new Region().withMessage(new Message().withText(from.getMessage())).withStartLine(from.getStartLine()).withEndLine(from.getEndLine()).withEndColumn(from.getEndColumn());
        ArtifactLocation artifactLocation = new ArtifactLocation().withUri(from.getFile());
        PhysicalLocation logicalLocations = new PhysicalLocation().withRegion(region).withArtifactLocation(artifactLocation);
        List<Location> locations = Arrays.asList(new Location().withPhysicalLocation(logicalLocations));
        return new Result().withRuleId(from.getRule()).withMessage(new Message().withText(from.getMessage())).withLevel(level).withLocations(locations);
    }

    private static Result.Level toLevel(SEVERITY severity) {
        if (severity == SEVERITY.ERROR) {
            return Result.Level.ERROR;
        }
        if (severity == SEVERITY.WARN) {
            return Result.Level.WARNING;
        }
        return Result.Level.NONE;
    }
}

