/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.concurrent.NotThreadSafe;
import se.softhouse.common.strings.Lines;
import se.softhouse.common.strings.StringBuilders;
import se.softhouse.common.strings.StringsUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.CommandLineParserInstance;
import se.softhouse.jargo.ProgramInformation;

@NotThreadSafe
public final class Usage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Collection<Argument<?>> unfilteredArguments;
    private transient String errorMessage = "";
    private final transient Locale locale;
    private final transient ProgramInformation program;
    private final transient boolean forCommand;
    private transient int columnWidth = 80;
    private transient String fromSerializedUsage = null;
    private transient int indexOfDescriptionColumn;
    private transient ImmutableList<Argument<?>> argumentsToPrint;
    private static final int SPACES_BETWEEN_COLUMNS = 4;
    private static final Joiner NAME_JOINER = Joiner.on((String)", ");

    Usage(Collection<Argument<?>> arguments, Locale locale, ProgramInformation program, boolean forCommand) {
        this.unfilteredArguments = arguments;
        this.locale = locale;
        this.program = program;
        this.forCommand = forCommand;
    }

    Usage(CommandLineParserInstance parser) {
        this.unfilteredArguments = parser.allArguments();
        this.locale = parser.locale();
        this.program = parser.programInformation();
        this.forCommand = parser.isCommandParser();
    }

    private Usage(String fromSerializedUsage) {
        this(null, null, null, false);
        this.fromSerializedUsage = fromSerializedUsage;
    }

    Usage withErrorMessage(String message) {
        this.errorMessage = (String)Preconditions.checkNotNull((Object)message);
        return this;
    }

    public String toString() {
        return this.usage();
    }

    private String usage() {
        if (this.fromSerializedUsage != null) {
            return this.fromSerializedUsage;
        }
        this.init();
        StringBuilder builder = this.newStringBuilder();
        this.printOn(builder);
        return builder.toString();
    }

    public void printOn(Appendable target) throws IOException {
        if (this.fromSerializedUsage != null) {
            target.append(this.fromSerializedUsage);
        } else {
            this.init();
            this.appendUsageTo(target);
        }
    }

    public void printOn(PrintStream target) {
        try {
            this.printOn((Appendable)target);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public void printOn(StringBuilder target) {
        try {
            this.printOn((Appendable)target);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private void appendUsageTo(Appendable builder) throws IOException {
        builder.append(this.errorMessage);
        builder.append(this.header());
        for (Argument arg : this.argumentsToPrint) {
            Row forArgument = this.usageForArgument(arg);
            this.appendRowTo(forArgument, builder);
        }
    }

    private String header() {
        if (this.forCommand) {
            return this.hasArguments() ? StringsUtil.NEWLINE : "";
        }
        String mainUsage = "Usage: " + this.program.programName();
        if (this.hasArguments()) {
            mainUsage = mainUsage + " [Arguments]";
        }
        mainUsage = mainUsage + StringsUtil.NEWLINE + Lines.wrap(this.program.programDescription(), this.columnWidth, this.locale);
        if (this.hasArguments()) {
            mainUsage = mainUsage + StringsUtil.NEWLINE + "Arguments" + ":" + StringsUtil.NEWLINE;
        }
        return mainUsage;
    }

    private void init() {
        if (this.argumentsToPrint == null) {
            Collection visibleArguments = Collections2.filter(this.unfilteredArguments, Argument.IS_VISIBLE);
            this.argumentsToPrint = ImmutableList.copyOf(this.sortedArguments(visibleArguments));
            this.indexOfDescriptionColumn = this.determineLongestNameColumn() + 4;
        }
    }

    private Iterable<Argument<?>> sortedArguments(Collection<Argument<?>> arguments) {
        Collection indexedArguments = Collections2.filter(arguments, Argument.IS_INDEXED);
        Collection indexedWithoutVariableArity = Collections2.filter((Collection)indexedArguments, (Predicate)Predicates.not(Argument.IS_OF_VARIABLE_ARITY));
        Collection indexedWithVariableArity = Collections2.filter((Collection)indexedArguments, Argument.IS_OF_VARIABLE_ARITY);
        ArrayList sortedArgumentsByName = Lists.newArrayList((Iterable)Collections2.filter(arguments, (Predicate)Predicates.not(Argument.IS_INDEXED)));
        Collections.sort(sortedArgumentsByName, Argument.NAME_COMPARATOR);
        return Iterables.concat((Iterable)indexedWithoutVariableArity, (Iterable)sortedArgumentsByName, (Iterable)indexedWithVariableArity);
    }

    private int determineLongestNameColumn() {
        int longestNameSoFar = 0;
        for (Argument arg : this.argumentsToPrint) {
            longestNameSoFar = Math.max(longestNameSoFar, this.lengthOfNameColumn(arg));
        }
        return Math.min(longestNameSoFar, this.maxNameColumnWidth());
    }

    private int lengthOfNameColumn(Argument<?> argument) {
        int namesLength = 0;
        for (String name : argument.names()) {
            namesLength += name.length();
        }
        int separatorLength = Math.max(0, ", ".length() * (argument.names().size() - 1));
        int metaLength = argument.metaDescriptionInLeftColumn().length();
        return namesLength + separatorLength + metaLength;
    }

    private int maxNameColumnWidth() {
        return this.columnWidth / 3 * 2;
    }

    private StringBuilder newStringBuilder() {
        return StringBuilders.withExpectedSize(2 * this.argumentsToPrint.size() * this.columnWidth);
    }

    private boolean hasArguments() {
        return !this.argumentsToPrint.isEmpty();
    }

    private Row usageForArgument(Argument<?> arg) {
        Row row = new Row();
        NAME_JOINER.appendTo(row.nameColumn, arg.names());
        row.nameColumn.append(arg.metaDescriptionInLeftColumn());
        String description = arg.description();
        if (!description.isEmpty()) {
            row.descriptionColumn.append((CharSequence)Lines.wrap(description, this.indexOfDescriptionColumn, this.columnWidth, this.locale));
            this.addIndicators(arg, row.descriptionColumn);
            row.descriptionColumn.append(StringsUtil.NEWLINE);
            this.valueExplanation(arg, row.descriptionColumn);
        } else {
            this.valueExplanation(arg, row.descriptionColumn);
            this.addIndicators(arg, row.descriptionColumn);
        }
        return row;
    }

    private <T> void addIndicators(Argument<T> arg, StringBuilder target) {
        if (arg.isRequired()) {
            target.append(" [Required]");
        }
        if (arg.isAllowedToRepeat()) {
            target.append(" [Supports Multiple occurrences]");
        }
    }

    private <T> void valueExplanation(Argument<T> arg, StringBuilder target) {
        String validValuesDescription = arg.descriptionOfValidValues(this.locale);
        if (!validValuesDescription.isEmpty()) {
            String meta = arg.metaDescriptionInRightColumn();
            target.append(meta + ": ").append(validValuesDescription);
        }
        if (arg.isRequired()) {
            return;
        }
        String descriptionOfDefaultValue = arg.defaultValueDescription(this.locale);
        if (descriptionOfDefaultValue != null) {
            if (!validValuesDescription.isEmpty()) {
                target.append(StringsUtil.NEWLINE);
            }
            String spaces = StringsUtil.spaces("Default: ".length());
            descriptionOfDefaultValue = descriptionOfDefaultValue.replace(StringsUtil.NEWLINE, StringsUtil.NEWLINE + spaces);
            target.append("Default: ").append(descriptionOfDefaultValue);
        }
    }

    private void appendRowTo(Row row, Appendable target) throws IOException {
        StringBuilder nameColumn = Lines.wrap(row.nameColumn, this.indexOfDescriptionColumn, this.locale);
        String descriptionColumn = row.descriptionColumn.toString();
        Iterable nameLines = Splitter.on((String)StringsUtil.NEWLINE).split((CharSequence)nameColumn);
        Iterator descriptionLines = Splitter.on((String)StringsUtil.NEWLINE).split((CharSequence)descriptionColumn).iterator();
        for (String nameLine : nameLines) {
            target.append(nameLine);
            if (descriptionLines.hasNext()) {
                int lengthOfNameColumn = nameLine.length();
                int paddingWidth = Math.max(1, this.indexOfDescriptionColumn - lengthOfNameColumn);
                target.append(StringsUtil.spaces(paddingWidth));
                target.append((CharSequence)descriptionLines.next());
            }
            target.append(StringsUtil.NEWLINE);
        }
        while (descriptionLines.hasNext()) {
            target.append(StringsUtil.spaces(this.indexOfDescriptionColumn));
            target.append((CharSequence)descriptionLines.next());
            target.append(StringsUtil.NEWLINE);
        }
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static final class SerializationProxy
    implements Serializable {
        private final String serializedUsage;
        private static final long serialVersionUID = 1L;

        private SerializationProxy(Usage usage) {
            this.serializedUsage = usage.usage();
        }

        private Object readResolve() {
            return new Usage(this.serializedUsage);
        }
    }

    @VisibleForTesting
    static final class Row {
        private final StringBuilder nameColumn = new StringBuilder();
        private final StringBuilder descriptionColumn = new StringBuilder();

        Row() {
        }

        public String toString() {
            return this.nameColumn.toString() + " " + this.descriptionColumn.toString();
        }
    }
}

