/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import se.softhouse.common.strings.Describable;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.Command;
import se.softhouse.jargo.CommandLineParserInstance;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.ProgramInformation;
import se.softhouse.jargo.StringParsers;
import se.softhouse.jargo.Usage;

@ThreadSafe
public final class CommandLineParser {
    static final Locale US_BY_DEFAULT = Locale.US;
    @GuardedBy(value="modifyGuard")
    private volatile CommandLineParserInstance cachedParser;
    private final Lock modifyGuard = new ReentrantLock();

    private CommandLineParser(Iterable<Argument<?>> argumentDefinitions) {
        this.cachedParser = new CommandLineParserInstance(argumentDefinitions);
    }

    CommandLineParserInstance parser() {
        return this.cachedParser;
    }

    @CheckReturnValue
    @Nonnull
    public static CommandLineParser withArguments(Argument<?> ... argumentDefinitions) {
        return new CommandLineParser(Arrays.asList(argumentDefinitions));
    }

    @CheckReturnValue
    @Nonnull
    public static CommandLineParser withArguments(Iterable<Argument<?>> argumentDefinitions) {
        return new CommandLineParser(argumentDefinitions);
    }

    @CheckReturnValue
    @Nonnull
    public static CommandLineParser withCommands(Command ... commands) {
        return new CommandLineParser(CommandLineParser.commandsToArguments(commands));
    }

    public static <E extends Enum<E> & Describable> CommandLineParser withCommands(Class<E> commandEnum) {
        return new CommandLineParser(CommandLineParser.commandsToArguments(commandEnum));
    }

    @Nonnull
    public ParsedArguments parse(String ... actualArguments) throws ArgumentException {
        return this.parser().parse(Arrays.asList(actualArguments));
    }

    @Nonnull
    public ParsedArguments parse(Iterable<String> actualArguments) throws ArgumentException {
        return this.parser().parse(actualArguments);
    }

    @CheckReturnValue
    @Nonnull
    public Usage usage() {
        return new Usage(this.parser());
    }

    @CheckReturnValue
    @Nonnull
    public CommandLineParser andCommands(Command ... commandsToAlsoSupport) {
        this.verifiedAdd(CommandLineParser.commandsToArguments(commandsToAlsoSupport));
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public CommandLineParser andArguments(Argument<?> ... argumentsToAlsoSupport) {
        this.verifiedAdd(Arrays.asList(argumentsToAlsoSupport));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifiedAdd(Collection<Argument<?>> argumentsToAdd) {
        try {
            this.modifyGuard.lock();
            ArrayList newDefinitions = Lists.newArrayList(this.parser().allArguments());
            newDefinitions.addAll(argumentsToAdd);
            this.cachedParser = new CommandLineParserInstance(newDefinitions, this.parser().programInformation(), this.parser().locale(), false);
        }
        finally {
            this.modifyGuard.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandLineParser programName(String programName) {
        try {
            this.modifyGuard.lock();
            ProgramInformation programInformation = this.parser().programInformation().programName(programName);
            this.cachedParser = new CommandLineParserInstance(this.parser().allArguments(), programInformation, this.parser().locale(), false);
        }
        finally {
            this.modifyGuard.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandLineParser programDescription(String programDescription) {
        try {
            this.modifyGuard.lock();
            ProgramInformation programInformation = this.parser().programInformation().programDescription(programDescription);
            this.cachedParser = new CommandLineParserInstance(this.parser().allArguments(), programInformation, this.parser().locale(), false);
        }
        finally {
            this.modifyGuard.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandLineParser locale(Locale localeToUse) {
        try {
            this.modifyGuard.lock();
            this.cachedParser = new CommandLineParserInstance(this.parser().allArguments(), this.parser().programInformation(), (Locale)Preconditions.checkNotNull((Object)localeToUse), false);
        }
        finally {
            this.modifyGuard.unlock();
        }
        return this;
    }

    public String toString() {
        return this.usage().toString();
    }

    private static List<Argument<?>> commandsToArguments(Command ... commands) {
        ArrayList commandsAsArguments = Lists.newArrayListWithExpectedSize((int)commands.length);
        for (Command c : commands) {
            commandsAsArguments.add(Arguments.command(c).build());
        }
        return commandsAsArguments;
    }

    private static <E extends Enum<E> & Describable> List<Argument<?>> commandsToArguments(Class<E> commandEnum) {
        ArrayList commandsAsArguments = Lists.newArrayList();
        for (Enum command : (Enum[])commandEnum.getEnumConstants()) {
            Argument commandAsArgument = ((ArgumentBuilder.SimpleArgumentBuilder)((ArgumentBuilder.SimpleArgumentBuilder)new ArgumentBuilder.SimpleArgumentBuilder<Object>(new StringParsers.RunnableParser((Runnable)((Object)command))).names(command.name().toLowerCase(Locale.US))).description((Describable)((Object)command))).build();
            commandsAsArguments.add(commandAsArgument);
        }
        return commandsAsArguments;
    }
}

