/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.strings.Describable;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.StringsUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.CommandLineParserInstance;

@Immutable
public final class ArgumentExceptions {
    private ArgumentExceptions() {
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentException withMessage(Object message) {
        return new SimpleArgumentException(Describables.toString(message));
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentException withMessage(Object message, Throwable cause) {
        return new SimpleArgumentException(Describables.toString(message)).andCause(cause);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentException withMessage(Describable message) {
        return new SimpleArgumentException(message);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentException withMessage(Describable message, Throwable cause) {
        return new SimpleArgumentException(message).andCause(cause);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentException wrapException(Throwable exceptionToWrap) {
        return new WrappedArgumentException(exceptionToWrap);
    }

    @CheckReturnValue
    @Nonnull
    static ArgumentException forMissingArguments(Collection<Argument<?>> missingArguments) {
        return new MissingRequiredArgumentException(missingArguments);
    }

    @CheckReturnValue
    @Nonnull
    static ArgumentException forUnallowedRepetitionArgument(String unhandledArgument) {
        Preconditions.checkNotNull((Object)unhandledArgument);
        return new SimpleArgumentException(Describables.format("Non-allowed repetition of the argument %s", unhandledArgument));
    }

    @CheckReturnValue
    @Nonnull
    static ArgumentException forMissingParameter(Argument<?> argumentWithMissingParameter) {
        return new MissingParameterException(argumentWithMissingParameter);
    }

    @CheckReturnValue
    @Nonnull
    static ArgumentException forMissingNthParameter(MissingParameterException cause, int missingIndex) {
        return new MissingNthParameterException(cause.parameterDescription(), missingIndex).andCause(cause);
    }

    @Nonnull
    static ArgumentException forUnexpectedArgument(CommandLineParserInstance.ArgumentIterator arguments) {
        String unexpectedArgument = arguments.previous();
        String previousArgument = null;
        if (arguments.hasPrevious()) {
            previousArgument = arguments.previous();
        }
        return new UnexpectedArgumentException(unexpectedArgument, previousArgument);
    }

    static final class UnexpectedArgumentException
    extends ArgumentException {
        private final String unexpectedArgument;
        private final String previousArgument;
        private static final long serialVersionUID = 1L;

        private UnexpectedArgumentException(String unexpectedArgument, @Nullable String previousArgument) {
            this.unexpectedArgument = unexpectedArgument;
            this.previousArgument = previousArgument;
        }

        @Override
        protected String getMessage(String argumentNameOrcommandName) {
            String message = "Unexpected argument: " + this.unexpectedArgument;
            if (this.previousArgument != null) {
                message = message + ", previous argument: " + this.previousArgument;
            }
            return message;
        }
    }

    private static final class MissingNthParameterException
    extends ArgumentException {
        private final String parameterDescription;
        private final int missingIndex;
        private static final long serialVersionUID = 1L;

        private MissingNthParameterException(String parameterDescription, int missingIndex) {
            this.parameterDescription = parameterDescription;
            this.missingIndex = missingIndex;
        }

        @Override
        protected String getMessage(String argumentNameOrCommandName) {
            return String.format("Missing %s %s parameter for %s", StringsUtil.numberToPositionalString(this.missingIndex + 1), this.parameterDescription, argumentNameOrCommandName);
        }
    }

    static final class MissingParameterException
    extends ArgumentException {
        private final String parameterDescription;
        private static final long serialVersionUID = 1L;

        private MissingParameterException(Argument<?> argumentWithMissingParameter) {
            this.parameterDescription = argumentWithMissingParameter.metaDescriptionInRightColumn();
        }

        @Override
        protected String getMessage(String argumentNameOrcommandName) {
            return String.format("Missing %s parameter for %s", this.parameterDescription, argumentNameOrcommandName);
        }

        String parameterDescription() {
            return this.parameterDescription;
        }
    }

    private static final class MissingRequiredArgumentException
    extends ArgumentException {
        private final String missingArguments;
        private static final long serialVersionUID = 1L;

        private MissingRequiredArgumentException(Collection<Argument<?>> missingArguments) {
            this.missingArguments = missingArguments.toString();
        }

        @Override
        protected String getMessage(String argumentNameOrcommandName) {
            if (this.isCausedByCommand(argumentNameOrcommandName)) {
                return String.format("Missing required arguments for %s: %s", argumentNameOrcommandName, this.missingArguments);
            }
            return String.format("Missing required arguments: %s", this.missingArguments);
        }

        private boolean isCausedByCommand(@Nullable String argumentNameOrcommandName) {
            return argumentNameOrcommandName != null;
        }
    }

    private static final class WrappedArgumentException
    extends ArgumentException {
        private final Throwable wrappedException;
        private static final long serialVersionUID = 1L;

        WrappedArgumentException(Throwable wrappedException) {
            this.wrappedException = (Throwable)Preconditions.checkNotNull((Object)wrappedException);
            this.initCause(wrappedException);
        }

        @Override
        protected String getMessage(String argumentNameOrcommandName) {
            return this.wrappedException.getMessage();
        }
    }

    private static final class SimpleArgumentException
    extends ArgumentException {
        private final Describables.SerializableDescription message;
        private static final long serialVersionUID = 1L;

        private SimpleArgumentException(Describable message) {
            this.message = Describables.asSerializable(message);
        }

        @Override
        protected String getMessage(String argumentNameOrcommandName) {
            return this.message.description();
        }
    }
}

