/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.strings;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringsUtil {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final char TAB = '\t';

    private StringsUtil() {
    }

    @Nonnull
    @CheckReturnValue
    public static String spaces(int numberOfSpaces) {
        return Strings.repeat((String)" ", (int)numberOfSpaces);
    }

    public static String pointingAtIndex(int indexToPointAt) {
        return StringsUtil.spaces(indexToPointAt) + "^";
    }

    public static boolean startsWithAndHasMore(String input, String toStartWith) {
        return input.startsWith(toStartWith) && input.length() > toStartWith.length();
    }

    @Nonnull
    @CheckReturnValue
    public static String closestMatch(String input, Iterable<String> validOptions) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((!Iterables.isEmpty(validOptions) ? 1 : 0) != 0, (Object)"No valid options to match the input against");
        int shortestDistance = Integer.MAX_VALUE;
        String bestGuess = null;
        for (String validOption : validOptions) {
            int distance = StringsUtil.levenshteinDistance(input, validOption);
            if (distance >= shortestDistance) continue;
            shortestDistance = distance;
            bestGuess = validOption;
        }
        return bestGuess;
    }

    @Nonnull
    @CheckReturnValue
    public static List<String> closestMatches(String input, Iterable<String> validOptions, int maximumDistance) {
        Preconditions.checkNotNull((Object)input);
        if (Iterables.isEmpty(validOptions)) {
            return Collections.emptyList();
        }
        ArrayList closeMatches = Lists.newArrayList();
        for (String validOption : validOptions) {
            int distance = StringsUtil.levenshteinDistance(input, validOption);
            if (distance > maximumDistance) continue;
            closeMatches.add(new CloseMatch(validOption, distance));
        }
        Collections.sort(closeMatches, CloseMatch.BY_CLOSEST_MATCH_FIRST);
        return Lists.transform((List)closeMatches, (Function)CloseMatch.GET_VALUE);
    }

    public static int levenshteinDistance(String left, String right) {
        int leftIndex;
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0) {
            return rightLength;
        }
        if (rightLength == 0) {
            return leftLength;
        }
        int[] previousDistances = new int[leftLength + 1];
        int[] distances = new int[leftLength + 1];
        for (leftIndex = 0; leftIndex <= leftLength; ++leftIndex) {
            previousDistances[leftIndex] = leftIndex;
        }
        for (int rightIndex = 1; rightIndex <= rightLength; ++rightIndex) {
            char rightChar = right.charAt(rightIndex - 1);
            distances[0] = rightIndex;
            for (leftIndex = 1; leftIndex <= leftLength; ++leftIndex) {
                int insertionCost = distances[leftIndex - 1] + 1;
                int editCost = previousDistances[leftIndex] + 1;
                int deletionCost = previousDistances[leftIndex - 1];
                if (left.charAt(leftIndex - 1) != rightChar) {
                    // empty if block
                }
                distances[leftIndex] = Ints.min((int[])new int[]{insertionCost, editCost, ++deletionCost});
            }
            int[] temp = previousDistances;
            previousDistances = distances;
            distances = temp;
        }
        return previousDistances[leftLength];
    }

    @Nonnull
    @CheckReturnValue
    public static String numberToPositionalString(int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0, (Object)"Negative numbers don't have positions");
        switch (number) {
            case 0: {
                return "zeroth";
            }
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
        }
        return Integer.toString(number) + "th";
    }

    public static int indexOfNth(int nth, String needle, String haystack) {
        Preconditions.checkNotNull((Object)haystack);
        Preconditions.checkNotNull((Object)needle);
        Preconditions.checkArgument((nth > 0 ? 1 : 0) != 0, (String)"nth must be at least 1 (was %s)", (Object[])new Object[]{nth});
        int index = -1;
        for (int occurencesFound = 0; occurencesFound < nth; ++occurencesFound) {
            index = haystack.indexOf(needle, index + 1);
            if (index != -1) continue;
            break;
        }
        return index;
    }

    static final class CloseMatch {
        private final int measuredDistance;
        private final String value;
        static final Comparator<CloseMatch> BY_CLOSEST_MATCH_FIRST = new Comparator<CloseMatch>(){

            @Override
            public int compare(CloseMatch left, CloseMatch right) {
                return left.measuredDistance - right.measuredDistance;
            }
        };
        private static final Function<CloseMatch, String> GET_VALUE = new Function<CloseMatch, String>(){

            public String apply(@Nonnull CloseMatch input) {
                return input.value;
            }
        };

        private CloseMatch(String validOption, int distance) {
            this.measuredDistance = distance;
            this.value = validOption;
        }
    }
}

