/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Suppliers2 {
    private static final Class<?> OF_INSTANCE = Suppliers.ofInstance(null).getClass();

    private Suppliers2() {
    }

    public static <T> Supplier<List<T>> ofRepeatedElements(Supplier<? extends T> elementSupplier, int elementsToSupply) {
        Preconditions.checkNotNull(elementSupplier);
        Preconditions.checkArgument((elementsToSupply >= 0 ? 1 : 0) != 0, (Object)"elementsToSupply may not be negative");
        return new ListSupplier(elementSupplier, elementsToSupply);
    }

    public static boolean isSuppliedAlready(Supplier<?> supplier) {
        ListSupplier listSupplier;
        if (supplier.getClass().equals(OF_INSTANCE)) {
            return true;
        }
        return supplier instanceof ListSupplier && (listSupplier = (ListSupplier)supplier).elementSupplier.getClass().equals(OF_INSTANCE);
    }

    private static final class ListSupplier<T>
    implements Supplier<List<T>> {
        private final Supplier<? extends T> elementSupplier;
        private final int elementsToSupply;

        private ListSupplier(Supplier<? extends T> elementSupplier, int elementsToSupply) {
            this.elementSupplier = elementSupplier;
            this.elementsToSupply = elementsToSupply;
        }

        public List<T> get() {
            ArrayList result = Lists.newArrayListWithCapacity((int)this.elementsToSupply);
            for (int i = 0; i < this.elementsToSupply; ++i) {
                result.add(this.elementSupplier.get());
            }
            return result;
        }
    }
}

