/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.strings.Describables;

@Immutable
public final class Predicates2 {
    private Predicates2() {
    }

    public static <E> Predicate<List<? extends E>> listPredicate(Predicate<E> elementLimiter) {
        Preconditions.checkNotNull(elementLimiter);
        if (elementLimiter == Predicates.alwaysTrue()) {
            return Predicates.alwaysTrue();
        }
        return new ListPredicate(elementLimiter);
    }

    public static <T> Predicate<? super T> and(Predicate<? super T> first, Predicate<? super T> second) {
        if (first == Predicates.alwaysTrue()) {
            return (Predicate)Preconditions.checkNotNull(second);
        }
        if (second == Predicates.alwaysTrue()) {
            return (Predicate)Preconditions.checkNotNull(first);
        }
        return Predicates.and(first, second);
    }

    private static final class ListPredicate<E>
    implements Predicate<List<? extends E>> {
        private final Predicate<E> elementLimiter;

        private ListPredicate(Predicate<E> elementLimiter) {
            this.elementLimiter = elementLimiter;
        }

        public boolean apply(@Nonnull List<? extends E> values) {
            for (E value : values) {
                if (this.elementLimiter.apply(value)) continue;
                throw Describables.illegalArgument(Describables.format("'%s' is not %s", value, this.elementLimiter));
            }
            return true;
        }

        public String toString() {
            return this.elementLimiter.toString();
        }
    }
}

