/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.main;

import java.io.File;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;

public class Main {
    public static final String PARAM_SETTINGS_FILE = "-sf";
    public static final String PARAM_OUTPUT_FILE = "-of";
    public static final String PARAM_OUTPUT_STDOUT = "-std";
    public static final String PARAM_TEMPLATE = "-t";
    private static final String PARAM_REPO = "-r";
    private static final String PARAM_FROM_REF = "-fr";
    private static final String PARAM_TO_REF = "-tr";
    private static final String PARAM_FROM_COMMIT = "-fc";
    private static final String PARAM_TO_COMMIT = "-tc";
    private static final String PARAM_IGNORE_PATTERN = "-ip";
    private static final String PARAM_JIRA_SERVER = "-js";
    private static final String PARAM_JIRA_ISSUE_PATTERN = "-jp";
    private static final String PARAM_GITHUB_SERVER = "-gs";
    private static final String PARAM_GITHUB_PATTERN = "-gp";
    private static final String PARAM_CUSTOM_ISSUE_NAME = "-cn";
    private static final String PARAM_CUSTOM_ISSUE_PATTERN = "-cp";
    private static final String PARAM_CUSTOM_ISSUE_LINK = "-cl";
    private static final String PARAM_UNTAGGED_TAG_NAME = "-ut";

    public static void main(String[] args) throws Exception {
        Argument helpArgument = Arguments.helpArgument((String)"-h", (String[])new String[]{"--help"});
        Argument settingsArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_SETTINGS_FILE, "--settings-file"}).description("Use settings from file.")).build();
        Argument outputStdoutArgument = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)PARAM_OUTPUT_STDOUT, (String[])new String[]{"--stdout"}).description("Print builder to <STDOUT>.")).defaultValue(Boolean.valueOf(true)).build();
        Argument outputFileArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_OUTPUT_FILE, "--output-file"}).description("Write output to file.")).build();
        Argument templatePathArgument = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_TEMPLATE, "--template"}).description("Template to use. A default template will be used if not specified.")).defaultValue(null)).build();
        Argument untaggedTagNameArgument = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_UNTAGGED_TAG_NAME, "--untaggedName"}).description("When listing commits per tag, this will by the name of a virtual tag that contains commits not available in any git tag.")).defaultValue(null)).build();
        Argument fromRepoArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_REPO, "--repo"}).description("Repository.")).build();
        Argument fromRefArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_FROM_REF, "--fromRef"}).description("From ref.")).build();
        Argument toRefArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_TO_REF, "--toRef"}).description("To ref.")).build();
        Argument fromCommitArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_FROM_COMMIT, "--fromCommit"}).description("From commit.")).build();
        Argument toCommitArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_TO_COMMIT, "--toCommit"}).description("To commit.")).build();
        Argument ignoreCommitsIfMessageMatchesArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_IGNORE_PATTERN, "--ignorePattern"}).description("Ignore commits where pattern matches message.")).build();
        Argument jiraServerArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_JIRA_SERVER, "--jiraServer"}).description("Jira server. When a Jira server is given, the title of the Jira issues can be used in the changelog.")).build();
        Argument jiraIssuePatternArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_JIRA_ISSUE_PATTERN, "--jiraPattern"}).description("Jira issue pattern.")).build();
        Argument githubServerArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_GITHUB_SERVER, "--githubServer"}).description("Github server. When a Github server is given, the title of the Github issues can be used in the changelog.")).build();
        Argument githubIssuePatternArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_GITHUB_PATTERN, "--githubPattern"}).description("Github pattern.")).build();
        Argument customIssueNameArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_CUSTOM_ISSUE_NAME, "--customIssueName"}).description("Custom issue name.")).build();
        Argument customIssuePatternArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_CUSTOM_ISSUE_PATTERN, "--customIssuePattern"}).description("Custom issue pattern.")).build();
        Argument customIssueLinkArgument = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{PARAM_CUSTOM_ISSUE_LINK, "--customIssueLink"}).description("Custom issue link.")).build();
        try {
            ParsedArguments arg = CommandLineParser.withArguments((Argument[])new Argument[]{helpArgument, settingsArgument, outputStdoutArgument, outputFileArgument, templatePathArgument, fromCommitArgument, fromRefArgument, fromRepoArgument, toCommitArgument, toRefArgument, untaggedTagNameArgument, jiraIssuePatternArgument, jiraServerArgument, ignoreCommitsIfMessageMatchesArgument, githubIssuePatternArgument, githubServerArgument, customIssueLinkArgument, customIssueNameArgument, customIssuePatternArgument}).parse(args);
            GitChangelogApi changelogApiBuilder = GitChangelogApi.gitChangelogApiBuilder();
            if (arg.wasGiven(settingsArgument)) {
                changelogApiBuilder.withSettings(new File((String)arg.get(settingsArgument)).toURI().toURL());
            }
            if (arg.wasGiven(fromCommitArgument)) {
                changelogApiBuilder.withFromCommit((String)arg.get(fromCommitArgument));
                changelogApiBuilder.withFromRef(null);
            }
            if (arg.wasGiven(fromRefArgument)) {
                changelogApiBuilder.withFromCommit(null);
                changelogApiBuilder.withFromRef((String)arg.get(fromRefArgument));
            }
            if (arg.wasGiven(fromRepoArgument)) {
                changelogApiBuilder.withFromRepo((String)arg.get(fromRepoArgument));
            }
            if (arg.wasGiven(toCommitArgument)) {
                changelogApiBuilder.withToCommit((String)arg.get(toCommitArgument));
                changelogApiBuilder.withToRef(null);
            }
            if (arg.wasGiven(toRefArgument)) {
                changelogApiBuilder.withToCommit(null);
                changelogApiBuilder.withToRef((String)arg.get(toRefArgument));
            }
            if (arg.wasGiven(untaggedTagNameArgument)) {
                changelogApiBuilder.withUntaggedName((String)arg.get(untaggedTagNameArgument));
            }
            if (arg.wasGiven(ignoreCommitsIfMessageMatchesArgument)) {
                changelogApiBuilder.withIgnoreCommitsWithMesssage((String)arg.get(ignoreCommitsIfMessageMatchesArgument));
            }
            if (arg.wasGiven(templatePathArgument)) {
                changelogApiBuilder.withTemplatePath((String)arg.get(templatePathArgument));
            }
            if (arg.wasGiven(jiraIssuePatternArgument)) {
                changelogApiBuilder.withJiraIssuePattern((String)arg.get(jiraIssuePatternArgument));
            }
            if (arg.wasGiven(jiraServerArgument)) {
                changelogApiBuilder.withJiraServer((String)arg.get(jiraServerArgument));
            }
            if (arg.wasGiven(githubIssuePatternArgument)) {
                changelogApiBuilder.withGithubIssuePattern((String)arg.get(githubIssuePatternArgument));
            }
            if (arg.wasGiven(githubServerArgument)) {
                changelogApiBuilder.withGithubServer((String)arg.get(githubServerArgument));
            }
            if (arg.wasGiven(customIssueNameArgument) && arg.wasGiven(customIssuePatternArgument) && arg.wasGiven(customIssueLinkArgument)) {
                changelogApiBuilder.withCustomIssues((String)arg.get(customIssueNameArgument), (String)arg.get(customIssuePatternArgument), (String)arg.get(customIssueLinkArgument));
            }
            if (((Boolean)arg.get(outputStdoutArgument)).booleanValue()) {
                changelogApiBuilder.toStdout();
            }
            if (arg.wasGiven(outputFileArgument)) {
                String filePath = (String)arg.get(outputFileArgument);
                changelogApiBuilder.toFile(filePath);
            }
        }
        catch (ArgumentException exception) {
            System.out.println(exception.getMessageAndUsage());
            System.exit(1);
        }
    }
}

