/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.Tag;
import se.bjurr.gitchangelog.internal.common.GitPredicates;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.issues.IssueParser;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.model.interfaces.IGitCommitReferer;
import se.bjurr.gitchangelog.internal.settings.Settings;

public class Transformer {
    private final Settings settings;

    public Transformer(Settings settings) {
        this.settings = settings;
    }

    public List<Tag> toTags(List<GitCommit> allCommits, List<GitTag> gitTags) {
        final Map<String, List<GitCommit>> commitsPerTag = this.getCommitsPerGitCommitReferer(allCommits, gitTags);
        List<String> withUnfilteredCommits = this.withUnfilteredCommits(commitsPerTag);
        List tags = Lists.transform(withUnfilteredCommits, (Function)new Function<String, Tag>(){

            public Tag apply(String input) {
                List gitCommits = (List)commitsPerTag.get(input);
                List<Commit> commits = Transformer.this.toCommits(gitCommits);
                List<Author> authors = Transformer.this.toAuthors(gitCommits);
                List<ParsedIssue> parsedIssues = new IssueParser(Transformer.this.settings, gitCommits).parseForIssues();
                List<Issue> issues = Transformer.this.toIssues(parsedIssues);
                return new Tag(Transformer.this.toReadableTagName(input), commits, authors, issues);
            }
        });
        return this.order(tags);
    }

    private String toReadableTagName(String input) {
        Matcher matcher = Pattern.compile(this.settings.getReadableTagPattern()).matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return input;
    }

    private List<Tag> order(Iterable<Tag> tags) {
        return Ordering.from((Comparator)new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                return o2.getCommit().getCommitTime().compareTo(o1.getCommit().getCommitTime());
            }
        }).sortedCopy(tags);
    }

    private List<String> withUnfilteredCommits(final Map<String, List<GitCommit>> commitsPerTag) {
        ArrayList tagsWithCommits = Lists.newArrayList((Iterable)Iterables.filter(commitsPerTag.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return Transformer.this.toCommits((Collection)commitsPerTag.get(input)).size() > 0;
            }
        }));
        return tagsWithCommits;
    }

    private <T extends IGitCommitReferer> Map<String, List<GitCommit>> getCommitsPerGitCommitReferer(List<GitCommit> allCommits, List<T> gitCommitReferer) {
        ImmutableMap perCommit = Maps.uniqueIndex(gitCommitReferer, (Function)new Function<T, GitCommit>(){

            public GitCommit apply(T input) {
                return input.getGitCommit();
            }
        });
        ImmutableMap stringPerCommit = Maps.toMap(perCommit.keySet(), (Function)new Function<GitCommit, String>((Map)perCommit){
            final /* synthetic */ Map val$perCommit;
            {
                this.val$perCommit = map;
            }

            public String apply(GitCommit input) {
                if (this.val$perCommit.containsKey(input)) {
                    return ((IGitCommitReferer)this.val$perCommit.get(input)).getName();
                }
                return null;
            }
        });
        return this.commitsPerString(allCommits, (Map<GitCommit, String>)stringPerCommit, this.settings.getUntaggedName());
    }

    private Map<String, List<GitCommit>> commitsPerString(List<GitCommit> allCommits, Map<GitCommit, String> stringPerCommit, String unMappedName) {
        HashMap commitsPerString = Maps.newHashMap();
        String currentName = unMappedName;
        for (GitCommit gitCommit : allCommits) {
            String tag = stringPerCommit.get(gitCommit);
            if (tag != null) {
                currentName = tag;
            }
            if (!commitsPerString.containsKey(currentName)) {
                commitsPerString.put(Preconditions.checkNotNull((Object)currentName, (Object)"currentTagName"), new ArrayList());
            }
            ((List)commitsPerString.get(currentName)).add(gitCommit);
        }
        return commitsPerString;
    }

    public List<Commit> toCommits(Collection<GitCommit> from) {
        ArrayList filteredCommits = Lists.newArrayList((Iterable)Iterables.filter(from, GitPredicates.ignoreCommits(this.settings.getIgnoreCommitsIfMessageMatches())));
        return Lists.transform((List)filteredCommits, (Function)new Function<GitCommit, Commit>(){

            public Commit apply(GitCommit c) {
                return Transformer.this.toCommit(c);
            }
        });
    }

    public List<Issue> toIssues(List<ParsedIssue> issues) {
        Iterable issuesWithCommits = Iterables.filter(issues, (Predicate)new Predicate<ParsedIssue>(){

            public boolean apply(ParsedIssue input) {
                return !Transformer.this.toCommits(input.getGitCommits()).isEmpty();
            }
        });
        return Lists.transform((List)Lists.newArrayList((Iterable)issuesWithCommits), (Function)new Function<ParsedIssue, Issue>(){

            public Issue apply(ParsedIssue input) {
                List<GitCommit> gitCommits = input.getGitCommits();
                return new Issue(Transformer.this.toCommits(gitCommits), Transformer.this.toAuthors(gitCommits), input.getName(), input.getIssue(), input.getLink());
            }
        });
    }

    private Commit toCommit(GitCommit gitCommit) {
        return new Commit(gitCommit.getAuthorName(), gitCommit.getAuthorEmailAddress(), this.format(gitCommit.getCommitTime()), gitCommit.getMessage(), gitCommit.getHash());
    }

    private String format(Date commitTime) {
        SimpleDateFormat df = new SimpleDateFormat(this.settings.getDateFormat());
        df.setTimeZone(TimeZone.getTimeZone(this.settings.getTimeZone()));
        return df.format(commitTime);
    }

    public List<Author> toAuthors(List<GitCommit> gitCommits) {
        ImmutableListMultimap commitsPerAuthor = Multimaps.index(gitCommits, (Function)new Function<GitCommit, String>(){

            public String apply(GitCommit input) {
                return input.getAuthorEmailAddress() + "-" + input.getAuthorName();
            }
        });
        ArrayList authorsWithCommits = Lists.newArrayList((Iterable)Iterables.filter((Iterable)commitsPerAuthor.keySet(), (Predicate)new Predicate<String>((Multimap)commitsPerAuthor){
            final /* synthetic */ Multimap val$commitsPerAuthor;
            {
                this.val$commitsPerAuthor = multimap;
            }

            public boolean apply(String input) {
                return Transformer.this.toCommits(this.val$commitsPerAuthor.get((Object)input)).size() > 0;
            }
        }));
        return Lists.transform((List)Lists.newArrayList((Iterable)authorsWithCommits), (Function)new Function<String, Author>((Multimap)commitsPerAuthor){
            final /* synthetic */ Multimap val$commitsPerAuthor;
            {
                this.val$commitsPerAuthor = multimap;
            }

            public Author apply(String input) {
                ArrayList gitCommitsOfSameAuthor = Lists.newArrayList((Iterable)this.val$commitsPerAuthor.get((Object)input));
                List<Commit> commitsOfSameAuthor = Transformer.this.toCommits(gitCommitsOfSameAuthor);
                return new Author(commitsOfSameAuthor.get(0).getAuthorName(), commitsOfSameAuthor.get(0).getAuthorEmailAddress(), commitsOfSameAuthor);
            }
        });
    }
}

