/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import se.bjurr.gitchangelog.api.model.Changelog;
import se.bjurr.gitchangelog.internal.git.GitRepo;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.issues.IssueParser;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.model.Transformer;
import se.bjurr.gitchangelog.internal.settings.CustomIssue;
import se.bjurr.gitchangelog.internal.settings.Settings;

public class GitChangelogApi {
    public static final String ZERO_COMMIT = "0000000000000000000000000000000000000000";
    private Settings settings;
    private String templateContent;
    private static GitRepo fakeGitRepo;

    @VisibleForTesting
    static void setFakeGitRepo(GitRepo fakeGitRepo) {
        GitChangelogApi.fakeGitRepo = fakeGitRepo;
    }

    public GitChangelogApi withSettings(URL url) {
        this.settings = Settings.fromFile(url);
        return this;
    }

    public static GitChangelogApi gitChangelogApiBuilder() {
        return new GitChangelogApi();
    }

    public GitChangelogApi withFromRepo(String fromRepo) {
        this.settings.setFromRepo(fromRepo);
        return this;
    }

    public GitChangelogApi withFromRef(String fromBranch) {
        this.settings.setFromRef(fromBranch);
        return this;
    }

    public GitChangelogApi withToRef(String toBranch) {
        this.settings.setToRef(toBranch);
        return this;
    }

    public Changelog getChangelog() {
        if (fakeGitRepo == null) {
            return this.getChangelog(new GitRepo(new File(this.settings.getFromRepo())));
        }
        return this.getChangelog(fakeGitRepo);
    }

    private Changelog getChangelog(GitRepo gitRepo) {
        ObjectId fromId = this.getId(gitRepo, this.settings.getFromRef(), this.settings.getFromCommit());
        ObjectId toId = this.getId(gitRepo, this.settings.getToRef(), this.settings.getToCommit());
        List<GitCommit> diff = gitRepo.getDiff(fromId, toId);
        List<GitTag> tags = gitRepo.getTags();
        List<ParsedIssue> issues = new IssueParser(this.settings, diff).parseForIssues();
        Transformer transformer = new Transformer(this.settings);
        return new Changelog(transformer.toCommits(diff), transformer.toTags(diff, tags), transformer.toAuthors(diff), transformer.toIssues(issues));
    }

    public GitChangelogApi withFromCommit(String fromCommit) {
        this.settings.setFromCommit(fromCommit);
        return this;
    }

    public GitChangelogApi withToCommit(String toCommit) {
        this.settings.setToCommit(toCommit);
        return this;
    }

    public GitChangelogApi withUntaggedName(String untaggedName) {
        this.settings.setUntaggedName(untaggedName);
        return this;
    }

    public GitChangelogApi withJiraIssuePattern(String jiraIssuePattern) {
        this.settings.setJiraIssuePattern(jiraIssuePattern);
        return this;
    }

    public GitChangelogApi withJiraServer(String jiraServer) {
        this.settings.setJiraServer(jiraServer);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithMesssage(String ignoreCommitsIfMessageMatches) {
        this.settings.setIgnoreCommitsIfMessageMatches(ignoreCommitsIfMessageMatches);
        return this;
    }

    public GitChangelogApi withGithubIssuePattern(String githubIssuePattern) {
        this.settings.setGithubIssuePattern(githubIssuePattern);
        return this;
    }

    public GitChangelogApi withGithubServer(String githubServer) {
        this.settings.setGithubServer(githubServer);
        return this;
    }

    public GitChangelogApi withCustomIssues(String name, String pattern, String link) {
        this.settings.setCustomIssues(Lists.newArrayList((Object[])new CustomIssue[]{new CustomIssue(name, pattern, link)}));
        return this;
    }

    public void toStdout() {
        String rendered = this.render();
        System.out.println(rendered);
    }

    public void toFile(String filePath) {
        try {
            File file = new File(filePath);
            Files.createParentDirs((File)file);
            Files.write((byte[])this.render().getBytes(), (File)file);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public GitChangelogApi withTemplatePath(String templatePath) {
        this.settings.setTemplatePath(templatePath);
        return this;
    }

    public GitChangelogApi withTemplateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    public String render() {
        try {
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            String templateContent = this.getTemplateContent();
            StringReader reader = new StringReader(templateContent);
            Mustache mustache = mf.compile((Reader)reader, this.settings.getTemplatePath());
            StringWriter writer = new StringWriter();
            mustache.execute((Writer)writer, (Object)this.getChangelog()).flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String getTemplateContent() {
        if (this.templateContent != null) {
            return this.templateContent;
        }
        try {
            return Resources.toString((URL)Resources.getResource((String)this.settings.getTemplatePath()), (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            File file = null;
            try {
                file = new File(this.settings.getTemplatePath());
                return Files.toString((File)file, (Charset)Charsets.UTF_8);
            }
            catch (IOException e2) {
                throw new RuntimeException("Cannot find on classpath (" + this.settings.getTemplatePath() + ") or filesystem (" + file.getAbsolutePath() + ").", e2);
            }
        }
    }

    private ObjectId getId(GitRepo gitRepo, String ref, String commit) {
        if (!Strings.isNullOrEmpty((String)ref)) {
            return gitRepo.getRef(ref);
        }
        if (!Strings.isNullOrEmpty((String)commit)) {
            return gitRepo.getCommit(commit);
        }
        throw new RuntimeException("Reference or commit must be defined!");
    }

    private GitChangelogApi() {
        URL resource = null;
        try {
            resource = Resources.getResource((String)"git-changelog-settings.json");
            this.settings = Settings.fromFile(resource.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find default config in " + resource, e);
        }
    }
}

