/*
 * Decompiled with CFR 0.152.
 */
package se.aaro.gustav.passwordstrengthmeter;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import se.aaro.gustav.passwordstrengthmeter.PasswordStrengthCalculator;
import se.aaro.gustav.passwordstrengthmeter.PasswordStrengthLevel;
import se.aaro.gustav.passwordstrengthmeter.R;
import se.aaro.gustav.passwordstrengthmeter.StrengthIndicatorView;

public class PasswordStrengthMeter
extends LinearLayout {
    private boolean animateChanges = true;
    private boolean showStrengthLabel = true;
    private boolean showStrengthBar = true;
    private int animationDuration = 300;
    private float strengthBarHeight;
    private float textSize;
    private Context context;
    private TextView strengthLabel;
    private StrengthIndicatorView strengthIndicatorView;
    private TextWatcher textWatcher;
    private EditText input;
    public static final int ID_MODIFIER = 321;
    private PasswordStrengthCalculator passwordStrengthCalculator;
    private PasswordStrengthLevel[] strengthLevels = new PasswordStrengthLevel[]{new PasswordStrengthLevel("Too short", 0x1060000), new PasswordStrengthLevel("Weak", 17170455), new PasswordStrengthLevel("Fair", 17170457), new PasswordStrengthLevel("Good", 17170456), new PasswordStrengthLevel("Strong", 17170450), new PasswordStrengthLevel("Very strong", 17170453)};
    private PasswordStrengthCalculator defaultPassWordStrengthCalculator = new PasswordStrengthCalculator(){

        @Override
        public int calculatePasswordSecurityLevel(String password) {
            boolean hasSpecial;
            boolean hasNumber;
            boolean hasLowercase;
            int level = 0;
            int minLength = PasswordStrengthMeter.this.passwordStrengthCalculator.getMinimumlength();
            if (password.length() < minLength) {
                return 0;
            }
            ++level;
            if ((double)password.length() >= (double)minLength * 1.5) {
                ++level;
            }
            boolean hasUppercase = !password.equals(password.toLowerCase());
            boolean bl = hasLowercase = !password.equals(password.toUpperCase());
            if (hasLowercase && hasUppercase) {
                ++level;
            }
            if (hasNumber = password.matches(".*\\d.*")) {
                ++level;
            }
            if (hasSpecial = password.matches(".*[!@#\u20ac\u00a3\u00a9\u00a7|\u2248$%^&*].*")) {
                ++level;
            }
            return level;
        }

        @Override
        public int getMinimumlength() {
            return 8;
        }

        @Override
        public boolean passwordAccepted(int level) {
            return level > 0;
        }

        @Override
        public void onPassWordAccepted(String password) {
        }
    };

    public PasswordStrengthMeter(Context context) {
        super(context);
        this.context = context;
        this.setId(View.generateViewId());
        this.initStrengthMeter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordStrengthMeter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PasswordStrengthMeter, 0, 0);
        try {
            this.showStrengthLabel = a.getBoolean(R.styleable.PasswordStrengthMeter_showStrengthLabel, true);
            this.showStrengthBar = a.getBoolean(R.styleable.PasswordStrengthMeter_showStrengthBar, true);
            this.animateChanges = a.getBoolean(R.styleable.PasswordStrengthMeter_animateChanges, true);
            this.animationDuration = a.getInt(R.styleable.PasswordStrengthMeter_animationDuration, this.animationDuration);
            this.strengthBarHeight = a.getDimension(R.styleable.PasswordStrengthMeter_strengthBarHeight, (float)this.convertDpToPx(5));
            this.textSize = a.getDimension(R.styleable.PasswordStrengthMeter_labelTextSize, (float)this.convertDpToPx(14));
        }
        finally {
            a.recycle();
        }
        this.initStrengthMeter();
    }

    public void setOrientation(int orientation) {
        super.setOrientation(0);
    }

    public void initStrengthMeter() {
        this.setOrientation(0);
        this.setVerticalGravity(16);
        this.setPasswordStrengthCalculator(this.defaultPassWordStrengthCalculator);
        if (this.strengthBarHeight == 0.0f) {
            this.strengthBarHeight = this.convertDpToPx(5);
        }
        if (this.showStrengthBar) {
            this.strengthIndicatorView = new StrengthIndicatorView(this.context);
            this.strengthIndicatorView.setPasswordStrengthLevels(this.strengthLevels);
            this.strengthIndicatorView.setAnimDuration(this.animationDuration);
            this.strengthIndicatorView.setAnimate(this.animateChanges);
            this.strengthIndicatorView.setHeight((int)this.strengthBarHeight);
            this.strengthIndicatorView.setId(View.generateViewId());
            this.addView(this.strengthIndicatorView);
        }
        if (this.showStrengthLabel) {
            this.strengthLabel = new TextView(this.context);
            this.strengthLabel.setGravity(0x800005);
            this.strengthLabel.setTextSize(0, this.textSize);
            this.addView((View)this.strengthLabel);
            this.strengthLabel.setMinWidth(this.getMaxWidth());
            this.strengthLabel.setText((CharSequence)this.strengthLevels[0].getDisplayName());
            this.strengthLabel.setTextColor(this.getResources().getColor(this.strengthLevels[0].getIndicatorColor()));
            this.strengthLabel.setId(View.generateViewId());
        }
        this.setLayoutParams();
        this.textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                PasswordStrengthMeter.this.refresh();
            }

            public void afterTextChanged(Editable editable) {
            }
        };
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
        this.strengthIndicatorView.setAnimDuration(animationDuration);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setLayoutParams();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            this.setLayoutParams();
        }
    }

    private void refresh() {
        if (this.input != null) {
            int level = this.normalizeLevel(this.passwordStrengthCalculator.calculatePasswordSecurityLevel(this.input.getText().toString()));
            if (this.showStrengthBar) {
                this.strengthIndicatorView.setSecurityLevel(this.normalizeLevel(level), false);
            }
            if (this.showStrengthLabel) {
                this.strengthLabel.setText((CharSequence)this.strengthLevels[level].getDisplayName());
                this.strengthLabel.setTextColor(this.getResources().getColor(this.strengthLevels[level].getIndicatorColor()));
            }
        }
    }

    private int getMaxWidth() {
        int max = 0;
        this.strengthLabel.setMinWidth(0);
        for (PasswordStrengthLevel level : this.strengthLevels) {
            this.strengthLabel.setText((CharSequence)level.getDisplayName());
            this.strengthLabel.measure(0, 0);
            max = this.strengthLabel.getMeasuredWidth() > max ? this.strengthLabel.getMeasuredWidth() : max;
        }
        return max;
    }

    private int normalizeLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level >= this.strengthLevels.length) {
            level = this.strengthLevels.length - 1;
        }
        return level;
    }

    private void setLayoutParams() {
        int labelWidth = 0;
        int marginEnd = 0;
        int marginStart = 0;
        if (this.showStrengthLabel) {
            this.strengthLabel.measure(0, 0);
            labelWidth = this.strengthLabel.getMeasuredWidth();
            marginEnd = this.convertDpToPx(2);
            marginStart = this.convertDpToPx(10);
            LinearLayout.LayoutParams labelparams = new LinearLayout.LayoutParams(-1, -2);
            labelparams.setMarginEnd(marginEnd);
            labelparams.setMarginStart(marginStart);
            this.strengthLabel.setLayoutParams((ViewGroup.LayoutParams)labelparams);
        }
        if (this.showStrengthBar) {
            int indicatorWidth = this.getWidth() - labelWidth - marginEnd - marginStart;
            if (indicatorWidth < 0) {
                indicatorWidth = 0;
            }
            LinearLayout.LayoutParams indicatorParams = new LinearLayout.LayoutParams(indicatorWidth, -2);
            indicatorParams.setMargins(0, this.convertDpToPx(8), 0, this.convertDpToPx(8));
            this.strengthIndicatorView.setLayoutParams((ViewGroup.LayoutParams)indicatorParams);
        }
    }

    public void setStrengthLevels(PasswordStrengthLevel[] strengthLevels) {
        this.strengthLevels = strengthLevels;
        this.strengthIndicatorView.setPasswordStrengthLevels(strengthLevels);
        this.strengthIndicatorView.invalidate();
        this.strengthLabel.setMinWidth(this.getMaxWidth());
        this.invalidate();
    }

    public void setShowStrengthIndicator(boolean showStrengthIndicator) {
        this.showStrengthBar = showStrengthIndicator;
        if (showStrengthIndicator) {
            this.strengthIndicatorView.setVisibility(0);
        } else {
            this.strengthIndicatorView.setVisibility(8);
        }
    }

    public void setEditText(EditText passwordInput) {
        passwordInput.addTextChangedListener(this.textWatcher);
        this.input = passwordInput;
    }

    public void setShowStrengthLabel(boolean showStrengthLabel) {
        this.showStrengthLabel = showStrengthLabel;
        if (showStrengthLabel) {
            this.strengthLabel.setVisibility(0);
        } else {
            this.strengthLabel.setVisibility(8);
        }
    }

    public void setPasswordStrengthCalculator(PasswordStrengthCalculator passwordStrengthCalculator) {
        this.passwordStrengthCalculator = passwordStrengthCalculator;
    }

    private int convertDpToPx(int dp) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }
}

