goog.provide('re_frame.fx');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed, other than that
 *   `:db` is guaranteed to be executed first.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__53767 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__53768 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__53768);

try{try{var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5754__auto___53919 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5754__auto___53919)){
var new_db_53920 = temp__5754__auto___53919;
var fexpr__53774_53921 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__53774_53921.cljs$core$IFn$_invoke$arity$1 ? fexpr__53774_53921.cljs$core$IFn$_invoke$arity$1(new_db_53920) : fexpr__53774_53921.call(null,new_db_53920));
} else {
}

var seq__53775 = cljs.core.seq(effects_without_db);
var chunk__53776 = null;
var count__53777 = (0);
var i__53778 = (0);
while(true){
if((i__53778 < count__53777)){
var vec__53802 = chunk__53776.cljs$core$IIndexed$_nth$arity$2(null,i__53778);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53802,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53802,(1),null);
var temp__5752__auto___53922 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53922)){
var effect_fn_53923 = temp__5752__auto___53922;
(effect_fn_53923.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53923.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53923.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53924 = seq__53775;
var G__53925 = chunk__53776;
var G__53926 = count__53777;
var G__53927 = (i__53778 + (1));
seq__53775 = G__53924;
chunk__53776 = G__53925;
count__53777 = G__53926;
i__53778 = G__53927;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53775);
if(temp__5754__auto__){
var seq__53775__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53775__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53775__$1);
var G__53928 = cljs.core.chunk_rest(seq__53775__$1);
var G__53929 = c__4591__auto__;
var G__53930 = cljs.core.count(c__4591__auto__);
var G__53931 = (0);
seq__53775 = G__53928;
chunk__53776 = G__53929;
count__53777 = G__53930;
i__53778 = G__53931;
continue;
} else {
var vec__53810 = cljs.core.first(seq__53775__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53810,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53810,(1),null);
var temp__5752__auto___53933 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53933)){
var effect_fn_53937 = temp__5752__auto___53933;
(effect_fn_53937.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53937.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53937.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53941 = cljs.core.next(seq__53775__$1);
var G__53942 = null;
var G__53943 = (0);
var G__53944 = (0);
seq__53775 = G__53941;
chunk__53776 = G__53942;
count__53777 = G__53943;
i__53778 = G__53944;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__53328__auto___53945 = re_frame.interop.now();
var duration__53329__auto___53946 = (end__53328__auto___53945 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__53329__auto___53946,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__53328__auto___53945);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__53767);
}} else {
var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5754__auto___53947 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5754__auto___53947)){
var new_db_53948 = temp__5754__auto___53947;
var fexpr__53818_53949 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__53818_53949.cljs$core$IFn$_invoke$arity$1 ? fexpr__53818_53949.cljs$core$IFn$_invoke$arity$1(new_db_53948) : fexpr__53818_53949.call(null,new_db_53948));
} else {
}

var seq__53819 = cljs.core.seq(effects_without_db);
var chunk__53820 = null;
var count__53821 = (0);
var i__53822 = (0);
while(true){
if((i__53822 < count__53821)){
var vec__53839 = chunk__53820.cljs$core$IIndexed$_nth$arity$2(null,i__53822);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53839,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53839,(1),null);
var temp__5752__auto___53950 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53950)){
var effect_fn_53951 = temp__5752__auto___53950;
(effect_fn_53951.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53951.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53951.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53952 = seq__53819;
var G__53953 = chunk__53820;
var G__53954 = count__53821;
var G__53955 = (i__53822 + (1));
seq__53819 = G__53952;
chunk__53820 = G__53953;
count__53821 = G__53954;
i__53822 = G__53955;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53819);
if(temp__5754__auto__){
var seq__53819__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53819__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53819__$1);
var G__53956 = cljs.core.chunk_rest(seq__53819__$1);
var G__53957 = c__4591__auto__;
var G__53958 = cljs.core.count(c__4591__auto__);
var G__53959 = (0);
seq__53819 = G__53956;
chunk__53820 = G__53957;
count__53821 = G__53958;
i__53822 = G__53959;
continue;
} else {
var vec__53845 = cljs.core.first(seq__53819__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53845,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53845,(1),null);
var temp__5752__auto___53963 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53963)){
var effect_fn_53964 = temp__5752__auto___53963;
(effect_fn_53964.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53964.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53964.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53965 = cljs.core.next(seq__53819__$1);
var G__53966 = null;
var G__53967 = (0);
var G__53968 = (0);
seq__53819 = G__53965;
chunk__53820 = G__53966;
count__53821 = G__53967;
i__53822 = G__53968;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.dispatch_later = (function re_frame$fx$dispatch_later(p__53853){
var map__53855 = p__53853;
var map__53855__$1 = cljs.core.__destructure_map(map__53855);
var effect = map__53855__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53855__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53855__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
return re_frame.interop.set_timeout_BANG_((function (){
return re_frame.router.dispatch(dispatch);
}),ms);
}
});
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
if(cljs.core.map_QMARK_(value)){
return re_frame.fx.dispatch_later(value);
} else {
var seq__53859 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__53860 = null;
var count__53861 = (0);
var i__53862 = (0);
while(true){
if((i__53862 < count__53861)){
var effect = chunk__53860.cljs$core$IIndexed$_nth$arity$2(null,i__53862);
re_frame.fx.dispatch_later(effect);


var G__53973 = seq__53859;
var G__53974 = chunk__53860;
var G__53975 = count__53861;
var G__53976 = (i__53862 + (1));
seq__53859 = G__53973;
chunk__53860 = G__53974;
count__53861 = G__53975;
i__53862 = G__53976;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53859);
if(temp__5754__auto__){
var seq__53859__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53859__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53859__$1);
var G__53977 = cljs.core.chunk_rest(seq__53859__$1);
var G__53978 = c__4591__auto__;
var G__53979 = cljs.core.count(c__4591__auto__);
var G__53980 = (0);
seq__53859 = G__53977;
chunk__53860 = G__53978;
count__53861 = G__53979;
i__53862 = G__53980;
continue;
} else {
var effect = cljs.core.first(seq__53859__$1);
re_frame.fx.dispatch_later(effect);


var G__53981 = cljs.core.next(seq__53859__$1);
var G__53982 = null;
var G__53983 = (0);
var G__53984 = (0);
seq__53859 = G__53981;
chunk__53860 = G__53982;
count__53861 = G__53983;
i__53862 = G__53984;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"fx","fx",-1237829572),(function (seq_of_effects){
if((!(cljs.core.sequential_QMARK_(seq_of_effects)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect expects a seq, but was given ",cljs.core.type(seq_of_effects)], 0));
} else {
var seq__53863 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,seq_of_effects));
var chunk__53864 = null;
var count__53865 = (0);
var i__53866 = (0);
while(true){
if((i__53866 < count__53865)){
var vec__53875 = chunk__53864.cljs$core$IIndexed$_nth$arity$2(null,i__53866);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53875,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53875,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5752__auto___53985 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53985)){
var effect_fn_53986 = temp__5752__auto___53985;
(effect_fn_53986.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53986.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53986.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__53987 = seq__53863;
var G__53988 = chunk__53864;
var G__53989 = count__53865;
var G__53990 = (i__53866 + (1));
seq__53863 = G__53987;
chunk__53864 = G__53988;
count__53865 = G__53989;
i__53866 = G__53990;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53863);
if(temp__5754__auto__){
var seq__53863__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53863__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53863__$1);
var G__53991 = cljs.core.chunk_rest(seq__53863__$1);
var G__53992 = c__4591__auto__;
var G__53993 = cljs.core.count(c__4591__auto__);
var G__53994 = (0);
seq__53863 = G__53991;
chunk__53864 = G__53992;
count__53865 = G__53993;
i__53866 = G__53994;
continue;
} else {
var vec__53880 = cljs.core.first(seq__53863__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53880,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53880,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5752__auto___53997 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5752__auto___53997)){
var effect_fn_53998 = temp__5752__auto___53997;
(effect_fn_53998.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53998.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53998.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__54000 = cljs.core.next(seq__53863__$1);
var G__54001 = null;
var G__54002 = (0);
var G__54003 = (0);
seq__53863 = G__54000;
chunk__53864 = G__54001;
count__53865 = G__54002;
i__53866 = G__54003;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__53902 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__53903 = null;
var count__53904 = (0);
var i__53905 = (0);
while(true){
if((i__53905 < count__53904)){
var event = chunk__53903.cljs$core$IIndexed$_nth$arity$2(null,i__53905);
re_frame.router.dispatch(event);


var G__54007 = seq__53902;
var G__54008 = chunk__53903;
var G__54009 = count__53904;
var G__54010 = (i__53905 + (1));
seq__53902 = G__54007;
chunk__53903 = G__54008;
count__53904 = G__54009;
i__53905 = G__54010;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53902);
if(temp__5754__auto__){
var seq__53902__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53902__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53902__$1);
var G__54011 = cljs.core.chunk_rest(seq__53902__$1);
var G__54012 = c__4591__auto__;
var G__54013 = cljs.core.count(c__4591__auto__);
var G__54014 = (0);
seq__53902 = G__54011;
chunk__53903 = G__54012;
count__53904 = G__54013;
i__53905 = G__54014;
continue;
} else {
var event = cljs.core.first(seq__53902__$1);
re_frame.router.dispatch(event);


var G__54017 = cljs.core.next(seq__53902__$1);
var G__54018 = null;
var G__54019 = (0);
var G__54020 = (0);
seq__53902 = G__54017;
chunk__53903 = G__54018;
count__53904 = G__54019;
i__53905 = G__54020;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__53909 = cljs.core.seq(value);
var chunk__53910 = null;
var count__53911 = (0);
var i__53912 = (0);
while(true){
if((i__53912 < count__53911)){
var event = chunk__53910.cljs$core$IIndexed$_nth$arity$2(null,i__53912);
clear_event(event);


var G__54028 = seq__53909;
var G__54029 = chunk__53910;
var G__54030 = count__53911;
var G__54031 = (i__53912 + (1));
seq__53909 = G__54028;
chunk__53910 = G__54029;
count__53911 = G__54030;
i__53912 = G__54031;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53909);
if(temp__5754__auto__){
var seq__53909__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53909__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53909__$1);
var G__54033 = cljs.core.chunk_rest(seq__53909__$1);
var G__54034 = c__4591__auto__;
var G__54035 = cljs.core.count(c__4591__auto__);
var G__54036 = (0);
seq__53909 = G__54033;
chunk__53910 = G__54034;
count__53911 = G__54035;
i__53912 = G__54036;
continue;
} else {
var event = cljs.core.first(seq__53909__$1);
clear_event(event);


var G__54037 = cljs.core.next(seq__53909__$1);
var G__54038 = null;
var G__54039 = (0);
var G__54040 = (0);
seq__53909 = G__54037;
chunk__53910 = G__54038;
count__53911 = G__54039;
i__53912 = G__54040;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
