goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e43178){var e = e43178;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___43311 = arguments.length;
var i__4737__auto___43312 = (0);
while(true){
if((i__4737__auto___43312 < len__4736__auto___43311)){
args__4742__auto__.push((arguments[i__4737__auto___43312]));

var G__43313 = (i__4737__auto___43312 + (1));
i__4737__auto___43312 = G__43313;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__43183){
var vec__43184 = p__43183;
var map__43187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43184,(0),null);
var map__43187__$1 = (((((!((map__43187 == null))))?(((((map__43187.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43187.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43187):map__43187);
var opts = map__43187__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43187__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43187__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43187__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43187__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__43189 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__43189__$1 = (((((!((map__43189 == null))))?(((((map__43189.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43189.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43189):map__43189);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43189__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43189__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__43179_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__43179_SHARP_);
}));

(web_socket.onclose = (function (p1__43180_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__43180_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__41419__auto___43320 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41420__auto__ = (function (){var switch__41349__auto__ = (function (state_43262){
var state_val_43263 = (state_43262[(1)]);
if((state_val_43263 === (7))){
var inst_43258 = (state_43262[(2)]);
var state_43262__$1 = state_43262;
var statearr_43264_43323 = state_43262__$1;
(statearr_43264_43323[(2)] = inst_43258);

(statearr_43264_43323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (20))){
var state_43262__$1 = state_43262;
var statearr_43265_43324 = state_43262__$1;
(statearr_43265_43324[(2)] = null);

(statearr_43265_43324[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (1))){
var inst_43192 = false;
var state_43262__$1 = (function (){var statearr_43266 = state_43262;
(statearr_43266[(7)] = inst_43192);

return statearr_43266;
})();
var statearr_43267_43325 = state_43262__$1;
(statearr_43267_43325[(2)] = null);

(statearr_43267_43325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (4))){
var inst_43208 = (state_43262[(8)]);
var inst_43210 = (state_43262[(9)]);
var inst_43202 = (state_43262[(10)]);
var inst_43208__$1 = (state_43262[(2)]);
var inst_43209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43208__$1,(0),null);
var inst_43210__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43208__$1,(1),null);
var inst_43211 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43210__$1,inst_43202);
var state_43262__$1 = (function (){var statearr_43268 = state_43262;
(statearr_43268[(11)] = inst_43209);

(statearr_43268[(8)] = inst_43208__$1);

(statearr_43268[(9)] = inst_43210__$1);

return statearr_43268;
})();
if(inst_43211){
var statearr_43269_43329 = state_43262__$1;
(statearr_43269_43329[(1)] = (5));

} else {
var statearr_43270_43330 = state_43262__$1;
(statearr_43270_43330[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (15))){
var inst_43243 = (state_43262[(2)]);
var state_43262__$1 = state_43262;
var statearr_43271_43331 = state_43262__$1;
(statearr_43271_43331[(2)] = inst_43243);

(statearr_43271_43331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (21))){
var inst_43254 = (state_43262[(2)]);
var state_43262__$1 = state_43262;
var statearr_43273_43332 = state_43262__$1;
(statearr_43273_43332[(2)] = inst_43254);

(statearr_43273_43332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (13))){
var state_43262__$1 = state_43262;
var statearr_43275_43333 = state_43262__$1;
(statearr_43275_43333[(2)] = null);

(statearr_43275_43333[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (6))){
var inst_43203 = (state_43262[(12)]);
var inst_43210 = (state_43262[(9)]);
var inst_43227 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43210,inst_43203);
var state_43262__$1 = state_43262;
if(inst_43227){
var statearr_43276_43334 = state_43262__$1;
(statearr_43276_43334[(1)] = (9));

} else {
var statearr_43277_43335 = state_43262__$1;
(statearr_43277_43335[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (17))){
var state_43262__$1 = state_43262;
var statearr_43278_43338 = state_43262__$1;
(statearr_43278_43338[(2)] = initial_ch);

(statearr_43278_43338[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (3))){
var inst_43260 = (state_43262[(2)]);
var state_43262__$1 = state_43262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43262__$1,inst_43260);
} else {
if((state_val_43263 === (12))){
var inst_43192 = (state_43262[(7)]);
var state_43262__$1 = state_43262;
if(cljs.core.truth_(inst_43192)){
var statearr_43279_43341 = state_43262__$1;
(statearr_43279_43341[(1)] = (16));

} else {
var statearr_43280_43342 = state_43262__$1;
(statearr_43280_43342[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (2))){
var inst_43203 = (state_43262[(12)]);
var inst_43202 = (state_43262[(10)]);
var inst_43202__$1 = open_ch;
var inst_43203__$1 = close_ch;
var inst_43204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43205 = [inst_43202__$1,inst_43203__$1];
var inst_43206 = (new cljs.core.PersistentVector(null,2,(5),inst_43204,inst_43205,null));
var state_43262__$1 = (function (){var statearr_43281 = state_43262;
(statearr_43281[(12)] = inst_43203__$1);

(statearr_43281[(10)] = inst_43202__$1);

return statearr_43281;
})();
return cljs.core.async.ioc_alts_BANG_(state_43262__$1,(4),inst_43206);
} else {
if((state_val_43263 === (19))){
var inst_43209 = (state_43262[(11)]);
var state_43262__$1 = state_43262;
var statearr_43282_43348 = state_43262__$1;
(statearr_43282_43348[(2)] = inst_43209);

(statearr_43282_43348[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (11))){
var inst_43256 = (state_43262[(2)]);
var state_43262__$1 = state_43262;
var statearr_43283_43353 = state_43262__$1;
(statearr_43283_43353[(2)] = inst_43256);

(statearr_43283_43353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (9))){
var inst_43208 = (state_43262[(8)]);
var inst_43233 = (state_43262[(13)]);
var inst_43232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43208,(0),null);
var inst_43233__$1 = chord.client.close_event__GT_maybe_error(inst_43232);
var state_43262__$1 = (function (){var statearr_43284 = state_43262;
(statearr_43284[(13)] = inst_43233__$1);

return statearr_43284;
})();
if(cljs.core.truth_(inst_43233__$1)){
var statearr_43286_43356 = state_43262__$1;
(statearr_43286_43356[(1)] = (12));

} else {
var statearr_43287_43357 = state_43262__$1;
(statearr_43287_43357[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (5))){
var inst_43208 = (state_43262[(8)]);
var inst_43218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43208,(0),null);
var inst_43219 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_43220 = [ws_chan];
var inst_43221 = cljs.core.PersistentHashMap.fromArrays(inst_43219,inst_43220);
var state_43262__$1 = (function (){var statearr_43288 = state_43262;
(statearr_43288[(14)] = inst_43218);

return statearr_43288;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43262__$1,(8),initial_ch,inst_43221);
} else {
if((state_val_43263 === (14))){
var inst_43246 = (state_43262[(2)]);
var inst_43247 = cljs.core.async.close_BANG_(ws_chan);
var inst_43248 = cljs.core.async.close_BANG_(initial_ch);
var state_43262__$1 = (function (){var statearr_43289 = state_43262;
(statearr_43289[(15)] = inst_43246);

(statearr_43289[(16)] = inst_43247);

return statearr_43289;
})();
var statearr_43291_43365 = state_43262__$1;
(statearr_43291_43365[(2)] = inst_43248);

(statearr_43291_43365[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (16))){
var state_43262__$1 = state_43262;
var statearr_43292_43366 = state_43262__$1;
(statearr_43292_43366[(2)] = read_ch__$1);

(statearr_43292_43366[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (10))){
var inst_43210 = (state_43262[(9)]);
var inst_43250 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43210,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_43262__$1 = state_43262;
if(inst_43250){
var statearr_43294_43371 = state_43262__$1;
(statearr_43294_43371[(1)] = (19));

} else {
var statearr_43296_43372 = state_43262__$1;
(statearr_43296_43372[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43263 === (18))){
var inst_43233 = (state_43262[(13)]);
var inst_43238 = (state_43262[(2)]);
var inst_43239 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43240 = [inst_43233];
var inst_43241 = cljs.core.PersistentHashMap.fromArrays(inst_43239,inst_43240);
var state_43262__$1 = state_43262;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43262__$1,(15),inst_43238,inst_43241);
} else {
if((state_val_43263 === (8))){
var inst_43223 = (state_43262[(2)]);
var inst_43224 = cljs.core.async.close_BANG_(initial_ch);
var inst_43192 = true;
var state_43262__$1 = (function (){var statearr_43297 = state_43262;
(statearr_43297[(17)] = inst_43224);

(statearr_43297[(18)] = inst_43223);

(statearr_43297[(7)] = inst_43192);

return statearr_43297;
})();
var statearr_43298_43373 = state_43262__$1;
(statearr_43298_43373[(2)] = null);

(statearr_43298_43373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__41350__auto__ = null;
var chord$client$state_machine__41350__auto____0 = (function (){
var statearr_43299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43299[(0)] = chord$client$state_machine__41350__auto__);

(statearr_43299[(1)] = (1));

return statearr_43299;
});
var chord$client$state_machine__41350__auto____1 = (function (state_43262){
while(true){
var ret_value__41351__auto__ = (function (){try{while(true){
var result__41352__auto__ = switch__41349__auto__(state_43262);
if(cljs.core.keyword_identical_QMARK_(result__41352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41352__auto__;
}
break;
}
}catch (e43300){var ex__41353__auto__ = e43300;
var statearr_43301_43381 = state_43262;
(statearr_43301_43381[(2)] = ex__41353__auto__);


if(cljs.core.seq((state_43262[(4)]))){
var statearr_43302_43382 = state_43262;
(statearr_43302_43382[(1)] = cljs.core.first((state_43262[(4)])));

} else {
throw ex__41353__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43383 = state_43262;
state_43262 = G__43383;
continue;
} else {
return ret_value__41351__auto__;
}
break;
}
});
chord$client$state_machine__41350__auto__ = function(state_43262){
switch(arguments.length){
case 0:
return chord$client$state_machine__41350__auto____0.call(this);
case 1:
return chord$client$state_machine__41350__auto____1.call(this,state_43262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__41350__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__41350__auto____0;
chord$client$state_machine__41350__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__41350__auto____1;
return chord$client$state_machine__41350__auto__;
})()
})();
var state__41421__auto__ = (function (){var statearr_43305 = f__41420__auto__();
(statearr_43305[(6)] = c__41419__auto___43320);

return statearr_43305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41421__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq43181){
var G__43182 = cljs.core.first(seq43181);
var seq43181__$1 = cljs.core.next(seq43181);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43182,seq43181__$1);
}));


//# sourceMappingURL=chord.client.js.map
