(ns gorilla-notes.components.rid3
  (:require
   [pinkie.jsrender :refer [render-js]]
   [rid3.core :as rid3 :refer [rid3->]]
   [reagent.core :as reagent]))

(defn viz [ratom]
  [rid3/viz
   {:id    "some-id"
    :ratom ratom
    :svg   {:did-mount (fn [node ratom]
                         (rid3-> node
                                 {:width  200
                                  :height 200
                                  :style  {:background-color "grey"}}))}
    }])

(def ratom (reagent/atom nil))

(defn ^{:category :ui} rid3
  [data]
  [:div
   "..."
   [viz ratom]])
