## [7.0.0](https://github.com/yoomoney/java-plugin/pull/15) (06-04-2022)

* Удалено использование `deprecated` `gradle api`;
* **breaking changes** Сборка плагина для gradle `7.4.1`;

## [6.1.0](https://github.com/yoomoney/java-plugin/pull/14) (05-04-2022)

* Поднята версия `jacoco` - `0.8.5` -> `0.8.7`

## [6.0.1](https://github.com/yoomoney/java-plugin/pull/13) (04-04-2022)

* Исправлен поиск временных ресурсов в случае, когда сборка `gradle` запускает задачу `clean`

## [6.0.0](https://github.com/yoomoney/java-plugin/pull/12) (04-04-2022)

* Добавлена совместимость плагина с `gradle 7`;
* Удалено использование внутреннего `gradle-api` - `org.gradle.api.internal`;
* **breaking changes** Версия `kotlin` поднята до `1.5.31`;
* **breaking changes** Плагин устанавливает зависимости для `implementation` и `runtimeOnly` конфигураций, вместо
устаревших `compile` и `runtime`.

## [5.0.0](https://github.com/yoomoney/java-plugin/pull/11) (17-03-2022)

* Исправлена работа проверки `UP-TO-DATE` для задачи запуска компонентных тестов;
* Исправлена передача параметра `sonar.projectName` в sonarqube - установленный параметр
в `javaModule` переопределяет стандартное значение.
* ***breaking changes*** Удалена `gradle` задача `overwriteTestReports`. Функциональность
перенесена в задачу запуска компонентных тестов.

## [4.5.0](https://github.com/yoomoney/java-plugin/pull/10) (04-03-2022)

* Добавлена поддержка инкрементального анализа в SonarQube

## [4.4.1](https://github.com/yoomoney/java-plugin/pull/9) (22-02-2022)

* Отключение репозитория bintray в тестовых скриптах;
* Отключение проксирования `system.out` при запуске `gradle` из тестов.

## [4.4.0](https://github.com/yoomoney/java-plugin/pull/8) (22-02-2022)

* Добавлена поддержка статического анализатора `SonarQube`. Добавленная функциональность дополняет базовую настройку
официального плагина `SonarQube`, а именно определяет следующие настройки:
1. Настройка путей к исходному и скомпилированному коду `unit` и компонентных тестов;
2. Настройка путей к результатам выполнения `unit` и компонентных тестов;
3. Настройка путей к отчету плагина проверки тестового покрытия кода (`jacoco`);
4. Настройка путей к отчету плагина `checkstyle`;
5. Настройка параметра `sonar.branch.name` (`git` ветка приложения);
6. Настройка путей к связанным библиотекам приложения.
* Добавлена функциональность настройки статического анализатора `SonarQube` через
настройки (`extensions`) текущего плагина (см `ru.yoomoney.gradle.plugins.backend.build.JavaExtension`);
* Добавлена функциональность включения статического анализа (`spotbugs`, `checkstyle` и `sonarqube`) в
стабильных ветках. По умолчанию поведение не изменилось - статический анализ производится в `development`
ветках - `feature`, `hotfix`, `bugfix`.

## [4.3.0](https://github.com/yoomoney/java-plugin/pull/6) (15-11-2021)

Проведен рефакторинг TestConfigurer. А именно, выделены задачи запуска тестов:
* Task "testJunit" - запуск unit тестов (только Junit)
* Task "testTestNG" - запуск unit тестов (только TestNG)
* Task "test" - запуск unit тестов (Junit и TestNG)
* Task "componentTestTest" - запуск компонентных тестов (только Junit)
* Task "componentTestTestNg" - запуск компонентных тестов (только TestNG)
* Task "componentTest" - запуск компонентных тестов (Junit и TestNG)
* Task "unitAndComponentTest" - запуск компонентных и unit тестов

## [4.2.1](https://github.com/yoomoney/java-plugin/pull/7) (11-11-2021)

* Добавлено исключение для mapstruct

## [4.2.0](https://github.com/yoomoney/java-plugin/pull/5) (26-08-2021)

* Переезд организации yoomoney-gradle-plugins -> yoomoney

## [4.1.2](https://github.com/yoomoney/java-plugin/pull/4) (19-05-2021)

* Добавлена информация о сборке и лицензии в README.md.

## [4.1.1](https://github.com/yoomoney/java-plugin/pull/3) (23-04-2021)

* Директория build/ удалена и добавлена в gitignore

## [4.1.0](https://github.com/yoomoney/java-plugin/pull/2) (19-03-2021)

* Сборка проекта переведена на gradle-project-plugin.

## [4.0.0](https://github.com/yoomoney/java-plugin/pull/1) (09-02-2021)

* Внесены изменения в связи с переходом в open source:
* Переименованы пакеты
* Плагин собирается без использования project-plugin, сборка полностью описывается в build.gradle
* Подключен artifact-release-plugin для автоматического выпуска релиза.
* Сборка переведена на travis (ранее использовался jenkins)
***breaking_changes***
* Удалено подключение check-dependencies-plugin и его конфигурация.
* Появились настройки jvmVersionPropertyName - описание в JavaExtension.
Необходимо прописать нужные значения при подключении в проект.

## [3.2.1]() (30-11-2020)

* Обновлена версия kotlin 1.3.71 -> 1.3.50

## [3.2.0]() (25-11-2020)

* Обновлен check-dependencies-plugin 6.0.2 -> 6.2.0

## [3.1.0]() (09-10-2020)

* Добавлена настройка snapshotsRepositories, в которой можно указать снапшотные репозитории. Они будут добавляться только для
фиче-веток.

## [3.0.0]() (03-09-2020)

* Теперь репозитории для поиска зависимостей определяются в настройке repositories.
Настройка additionalRepo удалена.

## [2.9.1]() (19-08-2020)

* Пофикшено добавление дополнительных репозиториев.

## [2.9.0]() (06-08-2020)

* Добавлена настройка для допольнительных репозиториев: additionalRepo.

## [2.8.0]() (03-07-2020)

* Поднята версия gradle: 6.0.1 -> 6.4.1.

## [2.7.0]() (11-06-2020)

* Включено падение билда при наличии конфликта мажорных версий для фиче-веток.

## [2.6.0]() (03-06-2020)

* В настройки плагина добавлены параметры `test` и `componentTest`, которые позволяют передавать настройки `TestNgExtension`.
* В `TestNgExtension` доступна настройка `listeners` со списком классов слушателей для обработки результатов выполнения тестов.
* В `TestNgExtension` доступна настройка `threadCount` с количеством потоков выполнения тестов, по умолчанию 8.
* В `TestNgExtension` доступна настройка `parallel` с режимом параллельного выполнения тестов, по умолчанию "classes".
Рекомендуется задавать `threadCount` через Extension плагина, а не через опции TestNG напрямую.

## [2.5.4]() (22-05-2020)

* Удалена проверка количества предупреждений компилятора `compiler`

## [2.5.3]() (20-05-2020)

* Обновлен yamoney-check-dependencies-plugin: 6.0.1 -> 6.0.2.

## [2.5.2]() (19-05-2020)

* Обновлен yamoney-check-dependencies-plugin: 6.0.0 -> 6.0.1.

## [2.5.1]() (19-05-2020)

* Обновлен yamoney-check-dependencies-plugin: 5.2.0 -> 6.0.0.
* Для проверки конфликтов мажорных версий временно отключено падение билда и включена отправка метрик,
чтобы исправить конфликты, которые появились за время не работы проверки.

## [2.5.0]() (28-04-2020)

* Поправил падающую сборку компонента, когда в ветке еще нет тегов

## [2.4.1]() (13-04-2020)

* Вместо SpotBugsPlugin применяется SpotBugsBasePlugin, который не создает автоматически таски для всех sourceSet.
Добавлено создание таски spotbugsMain.

## [2.4.0]() (12-04-2020)

* Обновлен yamoney-check-dependencies-plugin: 5.0.0 -> 5.2.0.
Перенесена конфигурация check-dependencies-plugin из component-project-plugin.

## [2.3.0]() (08-04-2020)

* Поднята версия spotbugs: 3.1.12 -> 4.0.1. Подняты версии зависимости и плагин spotbugs.
В некоторых компонентах понадобится поправить лимит static-analysis.findbugs,
так как при поднятии версии библиотеки добавились новые проверки.

## [2.2.2]() (26-03-2020)

* Для задачи `overwriteTestReports` поправлено чтение некорректных XML символов из файла логов.

## [2.2.1]() (25-03-2020)

* Удален spp-releases, spp-snapshots репозитории, в которых оставались calypso зависимости.
Используемые артефакты перенесены в репозиторий releases.

## [2.2.0]() (28-02-2020)

* Добавлена новая Gradle-задача `overwriteTestReports`, которая выполняется после прогона компонентных тестов для
перезаписывания логов в тестовых отчетах с разбиением по TraceID.

## [2.1.0]() (14-02-2020)

* Сборка на java 11

## [2.0.1]() (30-01-2020)

* Удален snapshots репозиторий.

## [2.0.0]() (29-01-2020)

* Поднята версия gradle: 4.10.2 -> 6.0.1. Подняты версии подключаемых плагинов.
**breaking changes**
* Для сборки плагина необходима 6 версия gradle.
* Больше нет удаления зависимостей между задачами.

## [1.19.0]() (23-12-2019)

* Добавлена возможность указать версию java через gradle свойство `yamoney-java-module-plugin.jvm-version`

## [1.18.3]() (06-12-2019)

* Добавил sourceset grafanaFromArtifact в список исключений при проверке зависимостей.

## [1.18.2]() (05-12-2019)

* Добавил sourceset grafana в список исключений при проверке зависимостей.

## [1.18.1]() (27-11-2019)

* Добавлено игнорирование закомментированных строк при чтении `static-analysis.properties`
* Исправлено удаление неизвестных ключей в `static-analysis.properties`

## [1.18.0]() (27-11-2019)

* Добавлено автоматическое обновление значений в файле `static-analysis.properties` при локальной сборке

## [1.17.1]() (26-11-2019)

* Обновлена зависимость ```yamoney-check-dependencies-plugin``` ```4.4.5``` -> ```4.5.3```

## [1.17.0]() (21-11-2019)

* Добавлена возможность запускать прогон компонетных тестов из обоих source set (componentTest, slowTest) на время переезда тестов в
правильный source set

## [1.16.0]() (08-11-2019)

* Убрано лишнее логирование при подсчете покрытия тестами

## [1.15.3]() (31-10-2019)

* Для таски `compileJava` добавлен аргумент компиляции `--release 8`, если версия java >= 9

## [1.15.2]() (24-10-2019)

* Из проверки spotbug исключен паттерн:
- BAS_BLOATED_ASSIGNMENT_SCOPE - переменная объявлена не в том скоупе, где она используется. Эксперименатальный метод

## [1.15.1]() (23-10-2019)

* Убрано требование одной (в строке) закрывющей скобки для цикла do..while

## [1.15.0]() (24-09-2019)

* При сборке в Jenkins теперь пишется актуальный coverage в формате удобным для copy paste в coverage.properties

## [1.14.3]() (05-09-2019)

* Из проверки spotbug исключены паттерны:,
- OCP_OVERLY_CONCRETE_PARAMETER - метод декларирует в аргументах конкретные классы, хотя в его теле используются только методы,
определенные в супер-классе или в реализуемом интерфейсе.
- CE_CLASS_ENVY - метод активнее использует методы другого класса, по сранению с методами своего собственного.
- CC_CYCLOMATIC_COMPLEXITY - метод имеет высокий показатель цикломатической сложности.

## [1.14.2]() (16-07-2019)

* Изменен формат вывода в лог таски `checkCoverage`
* Исправлен баг с проставлением timestamp при локальном автоподнятии coverage

## [1.14.1]() (11-07-2019)

* Исправлено отключение findbugs при удалении лимита findbugs static-analysis.properties

## [1.14.0]() (08-07-2019)

* Добавлено автоподнятие coverage при увеличении тестового покрытия при локальной сборке

## [1.13.2]() (04-07-2019)

* Переключение на последнюю версию gradle-project-plugin `5.+` после исправления ошибки
в процедуре проверки warnings (FileNotFoundException ../compile_error_out.txt)

## [1.13.1]() (04-07-2019)

* Фикс ошибки в процедуре проверки warnings (FileNotFoundException ../compile_error_out.txt)

## [1.13.0]() (03-07-2019)

* Исправлена проблема с отсутствием информации об ошибках компиляции в консоле

## [1.12.1]() (02-07-2019)

* В конфигурации плагина check-dependencies исправлено определение версии yamoney-libraries-dependencies.
При указании версии с "+" определяется новейшая возможная версия из релизного репозитория и подключается именно она.

## [1.12.0]() (19-06-2019)

1. Включение kotlin тестов по умолчанию, добавлять `System.setProperty("kotlinVersion", "")` теперь не требуется.
2. Убрано отключение findbugs и checkstyle при подключении kotlin-module-plugin. Могут начать находиться нарушения.
Если для проектов на kotlin не требуется findbugs или checkstyle, уберите соответствующие записи из static-analysis.properties.
3. При подключении KotlinPlugin добавляется зависимость таски compileJava от compileKotlin, иначе появляются
ошибки компиляции в проектах с двумя языках
4. Включен параллельный запуск test и slowTest в 8 потоков.
Если для вашего компонента параллельный запуск не работает, можно переопределить настройку в build.gradle, например,
так выглядела настройка до изменений:
```
slowTestTestNg {
useTestNG() {
options {
parallel = 'tests'
threadCount = 10
}
}
}

test {
useTestNG() {
options {
parallel = 'tests'
threadCount = 10
}
}
}
```

## [1.11.2]() (03-06-2019)

* Включать fork компиляцию только если установлена переменная JAVA_HOME

## [1.11.1]() (03-06-2019)

* Проверяем наличие тэгов перед получением описания при проверке стабильности ветки проекта

## [1.11.0]() (03-06-2019)

* Внесены изменения в проверку кол-ва warnings во время компиляции для поддержки параллельной сборки

## [1.10.0]() (28-05-2019)

* Добавлена таска componentTest для дальнейшего перехода на запуск из source set componentTest

## [1.9.4]() (27-05-2019)

Фикс определения тега как стабильной ветки

## [1.9.3]() (24-05-2019)

* По какой-то причине spotbugs создавал таски для всех source set'ов
* Ускорил выполнение тестов, убрав из всех вызов `clean`

## [1.9.2]() (23-05-2019)

* Добавил sourceset dockerJava в список исключений при проверке зависимостей.

## [1.9.1]() (23-05-2019)

* В настройке котлина для тестов отключена компиляция для `main` дерева исходников, так как она нарушает
последовательность тасок для плагинов, которые генерируют код, и тем самым приводит к ошибкам компиляции Java.

## [1.9.0]() (22-05-2019)

* Улучшена документация.
* Добавлен лимит `detekt` в static-analysis.properties для проектов на kotlin.

## [1.8.1]() (20-05-2019)

* errorprone временно удалён, из-за невозможности одновренного его использования и с java 8 и с java 11

## [1.8.0]() (17-05-2019)

* Добавлена конфигурация errorprone

## [1.7.2]() (16-05-2019)

* Coverage окргуляем до целых чисел и checkstyle только для feature веток

## [1.7.1]() (16-05-2019)

* Применение котлина для тестов откачено на условие по наличию проперти

## [1.7.0]() (14-05-2019)

* Добавлен плагин для подключения kotlin

## [1.6.2]() (14-05-2019)

* Добавлен репозиторий с Gradle плагинами

## [1.6.1]() (08-05-2019)

* Неверное условие по включению статического анализатора

## [1.6.0]() (08-05-2019)

* Добавлен статический анализатор SpotBugs

## [1.5.0]() (08-05-2019)

* Подключен yamoney-check-dependencies-plugin

## [1.4.2]() (08-05-2019)

* Фикс округления coverage

## [1.4.1]() (07-05-2019)

* Файл с конфигурацией checkstyle не резолвился при сборке

## [1.4.0]() (07-05-2019)

* Конфигурация checkstyle.gradle перенесена в java-module-plugin

## [1.3.1]() (07-05-2019)

* Починены проблемы со сборкой

## [1.3.0]() (07-05-2019)

* Конфигурация coverage.gradle перенесена в java-module-plugin

## [1.2.1]() (26-04-2019)

* Неверно искалась директория с гитом

## [1.2.0]() (26-04-2019)

* В java-module-plugin перенесен compile-check.gradle

## [1.1.0]() (26-04-2019)

* Добавлена сборка jar файла, настройки тестов и зависимостей

## [1.0.0]() (25-03-2019)

* Initial version