/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.kotlin;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektPlugin;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper;
import org.jlleitschuh.gradle.ktlint.KtlintExtension;
import org.jlleitschuh.gradle.ktlint.KtlintPlugin;
import org.jlleitschuh.gradle.ktlint.reporter.ReporterType;
import ru.yoomoney.gradle.plugins.backend.build.GetStaticAnalysisLimitKt;
import ru.yoomoney.gradle.plugins.backend.build.JavaPlugin;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lru/yoomoney/gradle/plugins/backend/kotlin/KotlinPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "configureDetekt", "configureKtlint", "detektConfig", "", "getDetektLimit", "", "java-plugin"})
public final class KotlinPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.getPluginManager().apply(JavaPlugin.class);
        target.getPluginManager().apply(KotlinPluginWrapper.class);
        target.getPluginManager().apply(KtlintPlugin.class);
        target.getPluginManager().apply(DetektPlugin.class);
        this.configureKtlint(target);
        this.configureDetekt(target);
        target.afterEvaluate(arg_0 -> KotlinPlugin.apply$lambda-0(target, arg_0));
    }

    private final void configureKtlint(Project target) {
        Object object = target.getExtensions().getByType(KtlintExtension.class);
        boolean bl = false;
        boolean bl2 = false;
        KtlintExtension $this$configureKtlint_u24lambda_u2d2 = (KtlintExtension)object;
        boolean bl3 = false;
        $this$configureKtlint_u24lambda_u2d2.reporters(KotlinPlugin::configureKtlint$lambda-2$lambda-1);
        Object[] objectArray = new String[]{"import-ordering", "final-newline"};
        $this$configureKtlint_u24lambda_u2d2.getDisabledRules().set((Iterable)SetsKt.setOf((Object[])objectArray));
        $this$configureKtlint_u24lambda_u2d2.getAndroid().set((Object)false);
    }

    private final void configureDetekt(Project target) {
        Object object = target.getExtensions().getByType(DetektExtension.class);
        boolean bl = false;
        boolean bl2 = false;
        DetektExtension $this$configureDetekt_u24lambda_u2d3 = (DetektExtension)object;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{"src/main/kotlin"};
        Object[] objectArray2 = target.files(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"target.files(DetektExten\u2026n.DEFAULT_SRC_DIR_KOTLIN)");
        $this$configureDetekt_u24lambda_u2d3.setSource((ConfigurableFileCollection)objectArray2);
        objectArray = new Object[]{((Directory)target.getLayout().getBuildDirectory().get()).file("detekt.yml").getAsFile()};
        objectArray2 = target.files(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"target.files(target.layo\u2026ile(\"detekt.yml\").asFile)");
        $this$configureDetekt_u24lambda_u2d3.setConfig((ConfigurableFileCollection)objectArray2);
        target.getTasks().create("copyDetektConfig", arg_0 -> KotlinPlugin.configureDetekt$lambda-5(target, this, arg_0));
        object = target.getTasks().withType(Detekt.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"target.tasks.withType(Detekt::class.java)");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Detekt it = (Detekt)element$iv;
            boolean bl4 = false;
            objectArray2 = new Object[]{"copyDetektConfig"};
            it.dependsOn(objectArray2);
        }
    }

    private final int getDetektLimit(Project target) {
        return ((Number)GetStaticAnalysisLimitKt.getStaticAnalysisLimit(target, "detekt").orElse(99999)).intValue() + 1;
    }

    private final String detektConfig() {
        InputStream inputStream = this.getClass().getResourceAsStream("/detekt.yml");
        String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(inputStream, StandardCharsets.UTF_8)");
        return string;
    }

    private static final void apply$lambda-0(Project $target, Project it) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Object[] objectArray = new Object[]{$target.getTasks().getByName("compileKotlin")};
        $target.getTasks().getByName("compileJava").dependsOn(objectArray);
    }

    private static final void configureKtlint$lambda-2$lambda-1(KtlintExtension.ReporterExtension it) {
        Object[] objectArray = new ReporterType[]{ReporterType.PLAIN_GROUP_BY_FILE, ReporterType.CHECKSTYLE};
        CollectionsKt.listOf((Object[])objectArray);
    }

    private static final void configureDetekt$lambda-5$lambda-4(KotlinPlugin this$0, Project $target, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        File config = File.createTempFile("detekt", ".yml");
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
        FilesKt.writeText$default((File)config, (String)StringsKt.replace((String)this$0.detektConfig(), (String)"%MAX_ISSUES%", (String)String.valueOf(this$0.getDetektLimit($target)), (boolean)false), null, (int)2, null);
        String[] stringArray = new String[]{"detekt.yml"};
        Path targetConfig = Paths.get($target.getBuildDir().getAbsolutePath(), stringArray);
        Files.deleteIfExists(targetConfig);
        Files.move(config.toPath(), targetConfig, new CopyOption[0]);
        Files.deleteIfExists(config.toPath());
    }

    private static final void configureDetekt$lambda-5(Project $target, KotlinPlugin this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.doLast(arg_0 -> KotlinPlugin.configureDetekt$lambda-5$lambda-4(this$0, $target, arg_0));
        Object[] objectArray = new Object[]{$target.getTasks().findByName("processResources")};
        it.dependsOn(objectArray);
    }
}

