/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.test;

import java.io.File;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/test/OverwriteTestReportsTask;", "", "xmlReportsPath", "", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Lorg/gradle/api/Project;)V", "collectTraceIdLogs", "", "Ljava/io/File;", "findTestLog", "Lorg/w3c/dom/Node;", "testLogs", "Lorg/w3c/dom/NodeList;", "name", "overwriteReport", "", "reportXmlDocument", "Lorg/w3c/dom/Document;", "traceIdLogsXmlDocument", "overwriteReportFile", "", "reportFile", "traceIdLogs", "overwriteTestCase", "testCase", "logs", "overwriteTestReports", "parseXmlDocument", "file", "Companion", "java-plugin"})
public final class OverwriteTestReportsTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String xmlReportsPath;
    @NotNull
    private final Project project;
    @NotNull
    private static final String TRACE_ID_LOGS_DIRECTORY = "tmp/logs/test";
    @NotNull
    private static final String TRACE_ID_LOG_FILE_PREFIX = "LOGS-";
    @NotNull
    private static final String TRACE_ID_LOG_FILE_POSTFIX = ".xml";
    @NotNull
    private static final String REPORT_FILE_PREFIX = "TEST-";
    @NotNull
    private static final String REPORT_FILE_POSTFIX = ".xml";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    @NotNull
    private static final String TEST_CASE_TAG_NAME = "testcase";
    @NotNull
    private static final String TEST_CASE_NAME_ATTRIBUTE_NAME = "name";
    @NotNull
    private static final String TEST_LOG_TAG_NAME = "testlog";
    @NotNull
    private static final String TEST_LOG_NAME_ATTRIBUTE_NAME = "name";
    @NotNull
    private static final String SYSTEM_OUT_TAG_NAME = "system-out";
    @NotNull
    private static final Regex XML_INVALID_CHARS;

    public OverwriteTestReportsTask(@NotNull String xmlReportsPath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)xmlReportsPath, (String)"xmlReportsPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.xmlReportsPath = xmlReportsPath;
        this.project = project;
    }

    public final void overwriteTestReports() {
        Map<String, File> traceIdLogs = this.collectTraceIdLogs();
        if (traceIdLogs.isEmpty()) {
            return;
        }
        ConfigurableFileTree reportsFileTree = this.project.fileTree((Object)this.xmlReportsPath);
        FileCollection fileCollection = reportsFileTree.filter(OverwriteTestReportsTask::overwriteTestReports$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"reportsFileTree\n        \u2026ith(REPORT_FILE_PREFIX) }");
        Iterable $this$forEach$iv = (Iterable)fileCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.overwriteReportFile(it, traceIdLogs);
        }
    }

    private final Map<String, File> collectTraceIdLogs() {
        boolean bl = false;
        Map traceIdLogs = new LinkedHashMap();
        ConfigurableFileTree logsFileTree = this.project.fileTree((Object)(this.project.getBuildDir() + "/tmp/logs/test"));
        Intrinsics.checkNotNullExpressionValue((Object)logsFileTree, (String)"logsFileTree");
        Iterable $this$forEach$iv = (Iterable)logsFileTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fullyQualifiedClassName;
            File it = (File)element$iv;
            boolean bl2 = false;
            Object object = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.name");
            int n = TRACE_ID_LOG_FILE_PREFIX.length();
            int n2 = it.getName().length() - ".xml".length();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = traceIdLogs;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            File file = it;
            n2 = 0;
            object.put(fullyQualifiedClassName, file);
        }
        return traceIdLogs;
    }

    private final void overwriteReportFile(File reportFile, Map<String, ? extends File> traceIdLogs) {
        Document traceIdLogsXmlDocument;
        Object object = reportFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reportFile.name");
        int n = REPORT_FILE_PREFIX.length();
        int n2 = reportFile.getName().length() - ".xml".length();
        boolean bl = false;
        String string = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String fullyQualifiedClassName = string;
        object = traceIdLogs;
        n = 0;
        Object object2 = object;
        bl = false;
        if (!object2.containsKey(fullyQualifiedClassName)) {
            this.project.getLogger().debug(Intrinsics.stringPlus((String)"Unknown report file to overwrite: reportFile=", (Object)reportFile));
            return;
        }
        File file = traceIdLogs.get(fullyQualifiedClassName);
        if (file == null) {
            object2 = Intrinsics.stringPlus((String)"TraceId log file is expected: className=", (Object)fullyQualifiedClassName);
            bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        File traceIdLogFile = file;
        Document reportXmlDocument = this.parseXmlDocument(reportFile);
        if (this.overwriteReport(reportXmlDocument, traceIdLogsXmlDocument = this.parseXmlDocument(traceIdLogFile))) {
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult output = new StreamResult(reportFile);
            DOMSource source = new DOMSource(reportXmlDocument);
            transformer.transform(source, output);
        }
    }

    private final boolean overwriteReport(Document reportXmlDocument, Document traceIdLogsXmlDocument) {
        NodeList testCases = reportXmlDocument.getElementsByTagName(TEST_CASE_TAG_NAME);
        NodeList testLogs = traceIdLogsXmlDocument.getElementsByTagName(TEST_LOG_TAG_NAME);
        boolean needToOverwriteFile = false;
        int n = 0;
        int n2 = testCases.getLength();
        if (n < n2) {
            do {
                int i = n++;
                Node testCase = testCases.item(i);
                String testCaseName = testCase.getAttributes().getNamedItem("name").getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)testLogs, (String)"testLogs");
                Intrinsics.checkNotNullExpressionValue((Object)testCaseName, (String)"testCaseName");
                Node testLog = this.findTestLog(testLogs, testCaseName);
                if (testLog == null) continue;
                String logs = testLog.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)testCase, (String)"testCase");
                Intrinsics.checkNotNullExpressionValue((Object)logs, (String)"logs");
                needToOverwriteFile = this.overwriteTestCase(testCase, logs);
            } while (n < n2);
        }
        return needToOverwriteFile;
    }

    private final boolean overwriteTestCase(Node testCase, String logs) {
        int n = 0;
        NodeList children = testCase.getChildNodes();
        int n2 = children.getLength();
        if (n < n2) {
            do {
                int i;
                Node child;
                if (!Intrinsics.areEqual((Object)(child = children.item(i = n++)).getNodeName(), (Object)SYSTEM_OUT_TAG_NAME)) continue;
                Document document = testCase.getOwnerDocument();
                CDATASection cdata = document.createCDATASection(logs);
                child.setTextContent(null);
                child.appendChild(cdata);
                return true;
            } while (n < n2);
        }
        this.project.getLogger().debug("'system-out' tag not found for given test case");
        return false;
    }

    private final Node findTestLog(NodeList testLogs, String name) {
        int n = 0;
        int n2 = testLogs.getLength();
        if (n < n2) {
            do {
                int i;
                Node testLog;
                String testLogName;
                if (!Intrinsics.areEqual((Object)(testLogName = (testLog = testLogs.item(i = n++)).getAttributes().getNamedItem("name").getTextContent()), (Object)name)) continue;
                return testLog;
            } while (n < n2);
        }
        return null;
    }

    private final Document parseXmlDocument(File file) {
        CharSequence charSequence = FilesKt.readText$default((File)file, null, (int)1, null);
        Regex regex = XML_INVALID_CHARS;
        Object object = "";
        boolean bl = false;
        String content = regex.replace(charSequence, (String)object);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(content));
        object = documentBuilder.parse(inputSource);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"documentBuilder.parse(inputSource)");
        return object;
    }

    private static final boolean overwriteTestReports$lambda-0(File it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
        return StringsKt.startsWith$default((String)string, (String)REPORT_FILE_PREFIX, (boolean)false, (int)2, null);
    }

    static {
        String string = "&#(x?)([A-Fa-f0-9]+);";
        boolean bl = false;
        XML_INVALID_CHARS = new Regex(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/test/OverwriteTestReportsTask$Companion;", "", "()V", "REPORT_FILE_POSTFIX", "", "REPORT_FILE_PREFIX", "SYSTEM_OUT_TAG_NAME", "TEST_CASE_NAME_ATTRIBUTE_NAME", "TEST_CASE_TAG_NAME", "TEST_LOG_NAME_ATTRIBUTE_NAME", "TEST_LOG_TAG_NAME", "TRACE_ID_LOGS_DIRECTORY", "TRACE_ID_LOG_FILE_POSTFIX", "TRACE_ID_LOG_FILE_PREFIX", "XML_INVALID_CHARS", "Lkotlin/text/Regex;", "documentBuilderFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "transformerFactory", "Ljavax/xml/transform/TransformerFactory;", "java-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

