/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.spotbugs;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import ru.yoomoney.gradle.plugins.backend.build.JavaExtension;
import ru.yoomoney.gradle.plugins.backend.build.git.GitManager;
import ru.yoomoney.gradle.plugins.backend.build.staticanalysis.StaticAnalysisProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/spotbugs/SpotBugsConfigurer;", "", "()V", "applyCheckTask", "", "target", "Lorg/gradle/api/Project;", "init", "logSuccess", "bugsFound", "", "bugsLimit", "xmlReport", "Lcom/github/spotbugs/snom/SpotBugsReport;", "spotbugsEnabled", "", "gitManager", "Lru/yoomoney/gradle/plugins/backend/build/git/GitManager;", "spotbugsExclude", "", "updateIfLocalOrElseThrow", "staticAnalysis", "Lru/yoomoney/gradle/plugins/backend/build/staticanalysis/StaticAnalysisProperties;", "java-plugin"})
public final class SpotBugsConfigurer {
    public final void init(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        GitManager gitManager = new GitManager(target);
        SpotBugsExtension extension = (SpotBugsExtension)target.getExtensions().getByType(SpotBugsExtension.class);
        extension.getToolVersion().set((Object)"4.0.1");
        DirectoryProperty directoryProperty = extension.getReportsDir();
        Object[] objectArray = target.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"target.buildDir");
        directoryProperty.set(target.file((Object)FilesKt.resolve((File)objectArray, (String)"spotbugsReports")));
        extension.getEffort().set((Object)Effort.DEFAULT);
        extension.getReportLevel().set((Object)Confidence.MEDIUM);
        extension.getExcludeFilter().set(() -> SpotBugsConfigurer.init$lambda-0(target, this));
        extension.getIgnoreFailures().set((Object)true);
        objectArray = target.getTasks().create("spotbugsMain", SpotBugsTask.class);
        boolean bl = false;
        boolean bl2 = false;
        SpotBugsTask $this$init_u24lambda_u2d2 = (SpotBugsTask)objectArray;
        boolean bl3 = false;
        SourceSet mainSourceSet = (SourceSet)((JavaPluginExtension)$this$init_u24lambda_u2d2.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        $this$init_u24lambda_u2d2.getReports().create("xml");
        $this$init_u24lambda_u2d2.getMaxHeapSize().set((Object)"3g");
        Object object = $this$init_u24lambda_u2d2.getSourceDirs();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceDirs");
        Iterable iterable = (Iterable)object;
        object = mainSourceSet.getAllSource().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mainSourceSet.allSource.srcDirs");
        CollectionsKt.plus((Iterable)iterable, (Iterable)((Iterable)object));
        $this$init_u24lambda_u2d2.setClassDirs((FileCollection)mainSourceSet.getOutput());
        $this$init_u24lambda_u2d2.setAuxClassPaths(mainSourceSet.getCompileClasspath());
        $this$init_u24lambda_u2d2.onlyIf(arg_0 -> SpotBugsConfigurer.init$lambda-2$lambda-1(this, target, gitManager, arg_0));
        objectArray = new Object[]{"spotbugsMain"};
        target.getTasks().getByName("build").dependsOn(objectArray);
        this.applyCheckTask(target);
        objectArray = new Object[]{"checkFindBugsReport"};
        target.getTasks().getByName("spotbugsMain").finalizedBy(objectArray);
        target.getDependencies().add("spotbugsPlugins", (Object)"com.mebigfatguy.sb-contrib:sb-contrib:7.4.7");
        target.getDependencies().add("spotbugsPlugins", (Object)"com.h3xstream.findsecbugs:findsecbugs-plugin:1.10.1");
    }

    private final void applyCheckTask(Project target) {
        target.getTasks().create("checkFindBugsReport").doLast(arg_0 -> SpotBugsConfigurer.applyCheckTask$lambda-3(target, this, arg_0));
    }

    private final boolean spotbugsEnabled(Project target, GitManager gitManager) {
        JavaExtension javaModuleExtension = (JavaExtension)target.getExtensions().getByType(JavaExtension.class);
        if (javaModuleExtension.getAnalyseDevelopmentBranchesOnly() && !gitManager.isDevelopmentBranch()) {
            target.getLogger().warn("SpotBugs check is enabled on feature/ and hotfix/ and bugfix/ branches. Skipping.");
            return false;
        }
        return javaModuleExtension.getSpotbugsEnabled();
    }

    private final String spotbugsExclude() {
        InputStream inputStream = this.getClass().getResourceAsStream("/findbugs-exclude.xml");
        String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(inputStream, StandardCharsets.UTF_8)");
        return string;
    }

    private final void updateIfLocalOrElseThrow(Project target, StaticAnalysisProperties staticAnalysis, int bugsFound, int bugsLimit, SpotBugsReport xmlReport) {
        if (target.hasProperty("ci")) {
            throw new GradleException("SpotBugs limit is too high, must be " + bugsFound + ". Decrease it in file static-analysis.properties.");
        }
        staticAnalysis.setProperty("findbugs", bugsFound);
        staticAnalysis.store();
        this.logSuccess(target, bugsFound, bugsLimit, xmlReport);
    }

    private final void logSuccess(Project target, int bugsFound, int bugsLimit, SpotBugsReport xmlReport) {
        target.getLogger().lifecycle("SpotBugs successfully passed with " + bugsFound + " (limit=" + bugsLimit + ") errors. See the report at: " + xmlReport.getDestination());
    }

    private static final File init$lambda-0(Project $target, SpotBugsConfigurer this$0) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $target.getResources().getText().fromString(this$0.spotbugsExclude()).asFile();
    }

    private static final boolean init$lambda-2$lambda-1(SpotBugsConfigurer this$0, Project $target, GitManager $gitManager, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$gitManager, (String)"$gitManager");
        return this$0.spotbugsEnabled($target, $gitManager);
    }

    private static final void applyCheckTask$lambda-3(Project $target, SpotBugsConfigurer this$0, Task it) {
        File file;
        Integer findbugsLimit;
        StaticAnalysisProperties staticAnalysis;
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $target.getLogger().lifecycle("Run checkFindBugsReport");
        StaticAnalysisProperties staticAnalysisProperties = staticAnalysis = StaticAnalysisProperties.Companion.load($target);
        Integer n = findbugsLimit = staticAnalysisProperties == null ? null : staticAnalysisProperties.getProperty("findbugs");
        if (findbugsLimit == null) {
            $target.getLogger().warn("findbugs limit not found, skipping check");
            return;
        }
        Task task = $target.getTasks().getByName("spotbugsMain");
        if (task == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.github.spotbugs.snom.SpotBugsTask");
        }
        SpotBugsTask spotBugsTask = (SpotBugsTask)task;
        SpotBugsReport xmlReport = spotBugsTask.getReports().findByName("xml") != null ? (SpotBugsReport)spotBugsTask.getReports().findByName("xml") : (SpotBugsReport)spotBugsTask.getReports().create("xml");
        SpotBugsReport spotBugsReport = xmlReport;
        Object object = spotBugsReport == null ? null : ((file = spotBugsReport.getDestination()) == null ? null : Boolean.valueOf(file.exists()));
        Intrinsics.checkNotNull(object);
        if (!((Boolean)object).booleanValue()) {
            $target.getLogger().lifecycle("SpotBugs report not found: " + xmlReport.getDestination() + ". SpotBugs skipped.");
            return;
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlReport.getDestination());
        int bugsFound = document.getElementsByTagName("BugInstance").getLength();
        if (bugsFound > findbugsLimit) {
            throw new GradleException("Too much SpotBugs errors: actual=" + bugsFound + ", limit=" + findbugsLimit + ". See the report at: " + xmlReport.getDestination());
        }
        if (bugsFound < Integer.max(0, findbugsLimit - 10)) {
            this$0.updateIfLocalOrElseThrow($target, staticAnalysis, bugsFound, findbugsLimit, xmlReport);
        } else {
            this$0.logSuccess($target, bugsFound, findbugsLimit, xmlReport);
        }
    }
}

