/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.sonarqube;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import ru.yoomoney.gradle.plugins.backend.build.JavaExtension;
import ru.yoomoney.gradle.plugins.backend.build.git.GitManager;
import ru.yoomoney.gradle.plugins.backend.build.sonarqube.SonarqubeSettings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J=\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0013\"\u00020\rH\u0003\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006\u0016"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/sonarqube/SonarqubeIncrementalAnalysisConfigurer;", "", "()V", "configure", "", "project", "Lorg/gradle/api/Project;", "findModifiedFiles", "", "Ljava/io/File;", "isIncrementalAnalysisEnabled", "", "resolveClosestStableAncestor", "", "resolveMainSourcePaths", "", "modifiedFiles", "resolveSourceSetFilePaths", "sourceSet", "", "(Lorg/gradle/api/Project;Ljava/util/List;[Ljava/lang/String;)Ljava/util/Set;", "resolveTestSourcePaths", "java-plugin"})
@SuppressFBWarnings(value={"BC_BAD_CAST_TO_ABSTRACT_COLLECTION"})
public final class SonarqubeIncrementalAnalysisConfigurer {
    @NotNull
    public static final SonarqubeIncrementalAnalysisConfigurer INSTANCE = new SonarqubeIncrementalAnalysisConfigurer();

    private SonarqubeIncrementalAnalysisConfigurer() {
    }

    public final void configure(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.isIncrementalAnalysisEnabled(project)) {
            return;
        }
        List<File> list = this.findModifiedFiles(project);
        if (list == null) {
            return;
        }
        List<File> modifiedFiles = list;
        SonarQubeExtension sonarqubeExtension = (SonarQubeExtension)project.getExtensions().getByType(SonarQubeExtension.class);
        Set<String> mainSourcePaths = this.resolveMainSourcePaths(project, modifiedFiles);
        Set<String> testSourcePaths = this.resolveTestSourcePaths(project, modifiedFiles);
        sonarqubeExtension.properties(arg_0 -> SonarqubeIncrementalAnalysisConfigurer.configure$lambda-2(mainSourcePaths, testSourcePaths, arg_0));
        Object[] objectArray = new Object[]{mainSourcePaths.size(), testSourcePaths.size()};
        project.getLogger().lifecycle("[sonarqube] incremental analysis configured: mainSourcePaths.count={}, testSourcePaths.count={}", objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIncrementalAnalysisEnabled(Project project) {
        String string;
        SonarqubeSettings sonarqubeSettings = ((JavaExtension)project.getExtensions().getByType(JavaExtension.class)).getSonarqube();
        Object object = new GitManager(project);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            GitManager it = (GitManager)object;
            boolean bl3 = false;
            string = it.branchName();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        String currentBranch = string;
        if (!sonarqubeSettings.getIncrementalAnalysisEnabled()) return false;
        object = sonarqubeSettings.getStableBranches();
        bl = false;
        if (object.isEmpty()) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        if (sonarqubeSettings.getStableBranches().contains(currentBranch)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<File> findModifiedFiles(Project project) {
        Object object = this.resolveClosestStableAncestor(project);
        if (object == null) {
            return null;
        }
        Object[] closestStableAncestor = object;
        object = new Object[]{closestStableAncestor};
        project.getLogger().lifecycle("[sonarqube] found closest stable ancestor: commit={}", object);
        object = new GitManager(project);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            GitManager gitManager = (GitManager)object;
            boolean bl3 = false;
            Iterable iterable = gitManager.findModifiedFiles(gitManager.branchName(), (String)closestStableAncestor);
            boolean $i$f$filter = false;
            void var10_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl4 = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                File file = it.getAbsoluteFile();
                collection.add(file);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String resolveClosestStableAncestor(Project project) {
        SonarqubeSettings sonarqubeSettings = ((JavaExtension)project.getExtensions().getByType(JavaExtension.class)).getSonarqube();
        AutoCloseable autoCloseable = new GitManager(project);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object v0;
            void $this$minByOrNull$iv;
            String string;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            GitManager gitManager = (GitManager)autoCloseable;
            boolean bl3 = false;
            String currentBranch = gitManager.branchName();
            Iterable iterable = sonarqubeSettings.getStableBranches();
            boolean $i$f$mapNotNull = false;
            void var11_14 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String string2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl4 = false;
                String it2 = (String)element$iv$iv;
                boolean bl5 = false;
                if (gitManager.findRemoteBranch(it2) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                String it$iv$iv = string2;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                string = gitManager.findCommonAncestor(it, currentBranch);
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                string = TuplesKt.to((Object)it, (Object)gitManager.getCommitCount(currentBranch, it));
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Pair it3 = (Pair)minElem$iv;
                    boolean bl11 = false;
                    int minValue$iv = ((Number)it3.getSecond()).intValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it4 = (Pair)e$iv;
                        $i$a$-minByOrNull-SonarqubeIncrementalAnalysisConfigurer$resolveClosestStableAncestor$1$4 = false;
                        int v$iv = ((Number)it4.getSecond()).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Pair pair = v0;
            String string3 = pair == null ? null : (String)pair.getFirst();
            return string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Set<String> resolveMainSourcePaths(Project project, List<? extends File> modifiedFiles) {
        String[] stringArray = new String[]{"main"};
        return this.resolveSourceSetFilePaths(project, modifiedFiles, stringArray);
    }

    private final Set<String> resolveTestSourcePaths(Project project, List<? extends File> modifiedFiles) {
        String[] stringArray = new String[]{"test", "componentTest", "slowTest"};
        return this.resolveSourceSetFilePaths(project, modifiedFiles, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"PDP_POORLY_DEFINED_PARAMETER"})
    private final Set<String> resolveSourceSetFilePaths(Project project, List<? extends File> modifiedFiles, String ... sourceSet) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File modifiedFile;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        SourceSet it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        Iterable iterable = ArraysKt.toList((Object[])sourceSet);
        boolean $i$f$mapNotNull = false;
        void var8_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SourceSet sourceSet2;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((SourceSet)javaPluginExtension.getSourceSets().findByName(it2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            SourceSet it$iv$iv = sourceSet2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            it = (SourceSet)element$iv$iv2;
            boolean bl = false;
            element$iv$iv = it.getAllJava().getSourceDirectories();
            Intrinsics.checkNotNullExpressionValue(element$iv$iv, (String)"it.allJava.sourceDirectories");
            Iterable list$iv$iv = (Iterable)element$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set sourceSetDirectories = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$flatMap$iv = modifiedFiles;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                modifiedFile = (File)element$iv$iv3;
                boolean bl6 = false;
                Iterable $this$any$iv = sourceSetDirectories;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        File sourceDir = (File)element$iv;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)sourceDir, (String)"sourceDir");
                        if (!FilesKt.startsWith((File)modifiedFile, (File)sourceDir)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv3);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            modifiedFile = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = project.getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
            String string = FilesKt.relativeTo((File)it, (File)file).getPath();
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final void configure$lambda-2(Set $mainSourcePaths, Set $testSourcePaths, SonarQubeProperties it) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$mainSourcePaths, (String)"$mainSourcePaths");
        Intrinsics.checkNotNullParameter((Object)$testSourcePaths, (String)"$testSourcePaths");
        Map map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        String string = "sonar.inclusions";
        Collection collection = $mainSourcePaths;
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            object2 = "empty";
        } else {
            object2 = collection;
        }
        collection = object2;
        bl = false;
        map.put(string, collection);
        map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        string = "sonar.test.inclusions";
        collection = $testSourcePaths;
        bl = false;
        if (collection.isEmpty()) {
            boolean bl3 = false;
            object = "empty";
        } else {
            object = collection;
        }
        collection = object;
        bl = false;
        map.put(string, collection);
    }
}

