/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.sonarqube;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.jetbrains.annotations.NotNull;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarQubeTask;
import ru.yoomoney.gradle.plugins.backend.build.JavaExtension;
import ru.yoomoney.gradle.plugins.backend.build.git.GitManager;
import ru.yoomoney.gradle.plugins.backend.build.sonarqube.SonarqubeConfigurer;
import ru.yoomoney.gradle.plugins.backend.build.sonarqube.SonarqubeIncrementalAnalysisConfigurer;
import ru.yoomoney.gradle.plugins.backend.build.sonarqube.SonarqubeSettings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/sonarqube/SonarqubeConfigurer;", "", "()V", "init", "", "project", "Lorg/gradle/api/Project;", "isSonarqubeEnabled", "", "resolveCheckstyleReportPaths", "", "resolveDynamicProperties", "resolveJacocoReportPaths", "", "resolveStaticProperties", "resolveTestBinariesPaths", "resolveTestReportPaths", "resolveTestSourcePaths", "resolveTestSourceSets", "Lorg/gradle/api/tasks/SourceSet;", "java-plugin"})
@SuppressFBWarnings(value={"BC_BAD_CAST_TO_ABSTRACT_COLLECTION"})
public final class SonarqubeConfigurer {
    public final void init(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.afterEvaluate(arg_0 -> SonarqubeConfigurer.init$lambda-0(project, this, arg_0));
        TaskCollection taskCollection = project.getTasks().withType(SonarQubeTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(SonarQubeTask::class.java)");
        Iterable $this$forEach$iv = (Iterable)taskCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object[] objectArray;
            Checkstyle it;
            SonarQubeTask task = (SonarQubeTask)element$iv;
            boolean bl = false;
            task.onlyIf(arg_0 -> SonarqubeConfigurer.init$lambda-5$lambda-1(this, project, arg_0));
            task.doFirst(arg_0 -> SonarqubeConfigurer.init$lambda-5$lambda-2(this, project, arg_0));
            TaskCollection taskCollection2 = project.getTasks().withType(Checkstyle.class);
            Intrinsics.checkNotNullExpressionValue((Object)taskCollection2, (String)"project.tasks.withType(Checkstyle::class.java)");
            Iterable $this$forEach$iv2 = (Iterable)taskCollection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Checkstyle)element$iv2;
                boolean bl2 = false;
                objectArray = new Object[]{it};
                task.dependsOn(objectArray);
            }
            $this$forEach$iv2 = project.getTasks().withType(JacocoReport.class);
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"project.tasks.withType(JacocoReport::class.java)");
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (JacocoReport)element$iv2;
                boolean bl3 = false;
                objectArray = new Object[]{it};
                task.dependsOn(objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSonarqubeEnabled(Project project) {
        JavaExtension javaModuleExtension = (JavaExtension)project.getExtensions().getByType(JavaExtension.class);
        if (javaModuleExtension.getAnalyseDevelopmentBranchesOnly()) {
            boolean bl;
            AutoCloseable autoCloseable = new GitManager(project);
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                GitManager it = (GitManager)autoCloseable;
                boolean bl4 = false;
                bl = it.isDevelopmentBranch();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            if (!bl) {
                project.getLogger().warn("SonarQube is enabled on feature/ and hotfix/ and bugfix/ branches. Skipping.");
                return false;
            }
        }
        return javaModuleExtension.getSonarqube().getEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resolveStaticProperties(Project project) {
        String string;
        SonarqubeSettings sonarqubeSettings = ((JavaExtension)project.getExtensions().getByType(JavaExtension.class)).getSonarqube();
        SonarQubeExtension sonarqubeExtension = (SonarQubeExtension)project.getExtensions().getByType(SonarQubeExtension.class);
        AutoCloseable autoCloseable = new GitManager(project);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            GitManager it = (GitManager)autoCloseable;
            boolean bl3 = false;
            string = it.branchName();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        String currentBranch = string;
        sonarqubeExtension.properties(arg_0 -> SonarqubeConfigurer.resolveStaticProperties$lambda-8(sonarqubeSettings, currentBranch, arg_0));
    }

    private final void resolveDynamicProperties(Project project) {
        Set set = project.getAllprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.allprojects");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            Project cursor = (Project)element$iv;
            boolean bl = false;
            SonarQubeExtension extension = (SonarQubeExtension)cursor.getExtensions().getByType(SonarQubeExtension.class);
            extension.properties(arg_0 -> SonarqubeConfigurer.resolveDynamicProperties$lambda-10$lambda-9(this, cursor, arg_0));
        }
        if (project.getLogger().isDebugEnabled()) {
            TaskCollection taskCollection = project.getTasks().withType(SonarQubeTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(SonarQubeTask::class.java)");
            SonarQubeTask sonarqubeTask = (SonarQubeTask)CollectionsKt.firstOrNull((Iterable)((Iterable)taskCollection));
            taskCollection = sonarqubeTask;
            if (taskCollection != null && (object = taskCollection.getProperties()) != null) {
                Object $this$forEach$iv2 = object;
                boolean $i$f$forEach2 = false;
                Object object2 = $this$forEach$iv2;
                boolean bl = false;
                Iterator iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry $dstr$key$value = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry entry = $dstr$key$value;
                    boolean bl3 = false;
                    String key = (String)entry.getKey();
                    Map.Entry entry2 = $dstr$key$value;
                    boolean bl4 = false;
                    String value = (String)entry2.getValue();
                    project.getLogger().debug("[sonarqube] properties: {}={}", (Object)key, (Object)value);
                }
            }
        }
    }

    private final String resolveCheckstyleReportPaths(Project project) {
        String string;
        CheckstyleExtension checkstyleExtension = (CheckstyleExtension)project.getExtensions().findByType(CheckstyleExtension.class);
        if (checkstyleExtension == null) {
            string = null;
        } else {
            File file = checkstyleExtension.getReportsDir();
            if (file == null) {
                string = null;
            } else {
                File file2 = FilesKt.resolve((File)file, (String)"main.xml");
                if (file2 == null) {
                    string = null;
                } else {
                    File file3 = file2;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file3;
                    boolean bl3 = false;
                    File file4 = it.exists() ? file3 : null;
                    string = file4 == null ? null : file4.getAbsolutePath();
                }
            }
        }
        return string;
    }

    private final List<String> resolveJacocoReportPaths(Project project) {
        TaskCollection taskCollection = project.getTasks().withType(JacocoReport.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(JacocoReport::class.java)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)taskCollection)), (Function1)resolveJacocoReportPaths.1.INSTANCE), (Function1)resolveJacocoReportPaths.2.INSTANCE), (Function1)resolveJacocoReportPaths.3.INSTANCE), (Function1)resolveJacocoReportPaths.4.INSTANCE));
    }

    private final List<String> resolveTestReportPaths(Project project) {
        TaskCollection taskCollection = project.getTasks().withType(Test.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(Test::class.java)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)taskCollection)), (Function1)resolveTestReportPaths.1.INSTANCE), (Function1)resolveTestReportPaths.2.INSTANCE), (Function1)resolveTestReportPaths.3.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> resolveTestSourcePaths(Project project) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.resolveTestSourceSets(project);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SourceSet)element$iv$iv;
            boolean bl = false;
            FileCollection fileCollection = it.getAllSource().getSourceDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"it.allSource.sourceDirectories");
            Iterable list$iv$iv = (Iterable)fileCollection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!((File)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it2 = (File)element$iv$iv;
            boolean bl2 = false;
            if (it2.getAbsolutePath() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> resolveTestBinariesPaths(Project project) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.resolveTestSourceSets(project);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SourceSet)element$iv$iv;
            boolean bl = false;
            SourceSetOutput sourceSetOutput = it.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)sourceSetOutput, (String)"it.output");
            Iterable list$iv$iv = (Iterable)sourceSetOutput;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!((File)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it2 = (File)element$iv$iv;
            boolean bl2 = false;
            if (it2.getAbsolutePath() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final List<SourceSet> resolveTestSourceSets(Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        Object[] objectArray = new SourceSet[]{(SourceSet)javaPluginExtension.getSourceSets().findByName("test"), (SourceSet)javaPluginExtension.getSourceSets().findByName("componentTest"), (SourceSet)javaPluginExtension.getSourceSets().findByName("slowTest")};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final void init$lambda-0(Project $project, SonarqubeConfigurer this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SonarqubeIncrementalAnalysisConfigurer.INSTANCE.configure($project);
        this$0.resolveStaticProperties($project);
    }

    private static final boolean init$lambda-5$lambda-1(SonarqubeConfigurer this$0, Project $project, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return this$0.isSonarqubeEnabled($project);
    }

    private static final void init$lambda-5$lambda-2(SonarqubeConfigurer this$0, Project $project, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.resolveDynamicProperties($project);
    }

    private static final void resolveStaticProperties$lambda-8(SonarqubeSettings $sonarqubeSettings, String $currentBranch, SonarQubeProperties it) {
        Intrinsics.checkNotNullParameter((Object)$sonarqubeSettings, (String)"$sonarqubeSettings");
        Intrinsics.checkNotNullParameter((Object)$currentBranch, (String)"$currentBranch");
        if ($sonarqubeSettings.getProjectKey() != null) {
            it.getProperties().putIfAbsent("sonar.projectKey", $sonarqubeSettings.getProjectKey());
        }
        if ($sonarqubeSettings.getProjectName() != null) {
            Map map = it.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
            String string = "sonar.projectName";
            String string2 = $sonarqubeSettings.getProjectName();
            boolean bl = false;
            map.put(string, string2);
        }
        it.getProperties().putIfAbsent("sonar.branch.name", $currentBranch);
        if (!$sonarqubeSettings.getSupplyLibrariesPath()) {
            it.getProperties().put("sonar.java.libraries", "");
            it.getProperties().put("sonar.java.test.libraries", "");
        }
    }

    private static final void resolveDynamicProperties$lambda-10$lambda-9(SonarqubeConfigurer this$0, Project $cursor, SonarQubeProperties it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        String string = "sonar.junit.reportPaths";
        Intrinsics.checkNotNullExpressionValue((Object)$cursor, (String)"cursor");
        List<String> list = this$0.resolveTestReportPaths($cursor);
        boolean bl = false;
        map.put(string, list);
        map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        string = "sonar.coverage.jacoco.xmlReportPaths";
        list = this$0.resolveJacocoReportPaths($cursor);
        bl = false;
        map.put(string, list);
        map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        string = "sonar.java.checkstyle.reportPaths";
        list = this$0.resolveCheckstyleReportPaths($cursor);
        bl = false;
        map.put(string, list);
        map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        string = "sonar.tests";
        list = this$0.resolveTestSourcePaths($cursor);
        bl = false;
        map.put(string, list);
        map = it.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.properties");
        string = "sonar.java.test.binaries";
        list = this$0.resolveTestBinariesPaths($cursor);
        bl = false;
        map.put(string, list);
    }
}

