/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.jar;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.backend.build.JavaExtension;
import ru.yoomoney.gradle.plugins.backend.build.git.GitManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/jar/JarConfigurer;", "", "()V", "configureJar", "", "target", "Lorg/gradle/api/Project;", "configureRepos", "enableCompileJavaFork", "forceEncoding", "getHostName", "", "getJavaHomePath", "init", "isDevelopmentBranch", "", "optionalSourceSet", "resolutionStrategy", "targetJavaVersion", "java-plugin"})
public final class JarConfigurer {
    public final void init(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.forceEncoding(target);
        this.targetJavaVersion(target);
        this.configureRepos(target);
        this.optionalSourceSet(target);
        this.resolutionStrategy(target);
        this.configureJar(target);
        this.enableCompileJavaFork(target);
    }

    private final void configureJar(Project target) {
        Task task = target.getTasks().getByName("jar");
        if (task == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.jvm.tasks.Jar");
        }
        Jar jarTask = (Jar)task;
        task = jarTask;
        boolean bl = false;
        boolean bl2 = false;
        Task $this$configureJar_u24lambda_u2d2 = task;
        boolean bl3 = false;
        String buildDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        $this$configureJar_u24lambda_u2d2.manifest(arg_0 -> JarConfigurer.configureJar$lambda-2$lambda-0(buildDate, this, target, arg_0));
        $this$configureJar_u24lambda_u2d2.from((Object)target.getProjectDir(), JarConfigurer::configureJar$lambda-2$lambda-1);
    }

    private final String getHostName() {
        String string = InetAddress.getLocalHost().getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalHost().hostName");
        return string;
    }

    private final void resolutionStrategy(Project target) {
        target.getConfigurations().all(JarConfigurer::resolutionStrategy$lambda-4);
    }

    private final void optionalSourceSet(Project target) {
        Configuration optional = (Configuration)target.getConfigurations().create("optional");
        Object object = new Configuration[]{optional};
        target.getConfigurations().getByName("testImplementation").extendsFrom(object);
        object = target.getExtensions().getByType(JavaPluginExtension.class);
        boolean bl = false;
        boolean bl2 = false;
        JavaPluginExtension $this$optionalSourceSet_u24lambda_u2d5 = (JavaPluginExtension)object;
        boolean bl3 = false;
        ((SourceSet)$this$optionalSourceSet_u24lambda_u2d5.getSourceSets().getByName("main")).setCompileClasspath(((SourceSet)$this$optionalSourceSet_u24lambda_u2d5.getSourceSets().getByName("main")).getCompileClasspath().plus((FileCollection)target.getConfigurations().getByName("optional")));
    }

    private final void configureRepos(Project target) {
        target.afterEvaluate(arg_0 -> JarConfigurer.configureRepos$lambda-10(target, this, arg_0));
    }

    private final boolean isDevelopmentBranch(Project target) {
        return new GitManager(target).isDevelopmentBranch();
    }

    private final void targetJavaVersion(Project target) {
        target.afterEvaluate(arg_0 -> JarConfigurer.targetJavaVersion$lambda-15(target, arg_0));
    }

    private final void forceEncoding(Project target) {
        Task task = target.getTasks().getByName("compileJava");
        if (task == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.compile.JavaCompile");
        }
        task = (JavaCompile)task;
        boolean bl = false;
        boolean bl2 = false;
        Task $this$forceEncoding_u24lambda_u2d16 = task;
        boolean bl3 = false;
        $this$forceEncoding_u24lambda_u2d16.getOptions().setEncoding("UTF-8");
        task = target.getTasks().getByName("compileTestJava");
        if (task == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.compile.JavaCompile");
        }
        task = (JavaCompile)task;
        bl = false;
        bl2 = false;
        Task $this$forceEncoding_u24lambda_u2d17 = task;
        boolean bl4 = false;
        $this$forceEncoding_u24lambda_u2d17.getOptions().setEncoding("UTF-8");
    }

    private final void enableCompileJavaFork(Project target) {
        String javaHomePath = this.getJavaHomePath();
        if (javaHomePath != null) {
            Task task = target.getTasks().getByName("compileJava");
            if (task == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.compile.JavaCompile");
            }
            task = (JavaCompile)task;
            boolean bl = false;
            boolean bl2 = false;
            Task $this$enableCompileJavaFork_u24lambda_u2d18 = task;
            boolean bl3 = false;
            $this$enableCompileJavaFork_u24lambda_u2d18.getOptions().setFork(true);
            $this$enableCompileJavaFork_u24lambda_u2d18.getOptions().getForkOptions().setJavaHome(target.file((Object)javaHomePath));
        }
    }

    private final String getJavaHomePath() {
        return Jvm.current() != null ? Jvm.current().getJavaHome().getAbsolutePath() : (System.getProperty("java.home") != null ? System.getProperty("java.home") : System.getenv("JAVA_HOME"));
    }

    private static final void configureJar$lambda-2$lambda-0(String $buildDate, JarConfigurer this$0, Project $target, Manifest it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Implementation-Version", (Object)("built at " + $buildDate + " on " + this$0.getHostName())), TuplesKt.to((Object)"Bundle-SymbolicName", (Object)$target.getName()), TuplesKt.to((Object)"Built-By", (Object)System.getProperty("user.name")), TuplesKt.to((Object)"Built-Date", (Object)$buildDate), TuplesKt.to((Object)"Built-At", (Object)this$0.getHostName())};
        it.attributes(MapsKt.mapOf((Pair[])pairArray));
    }

    private static final void configureJar$lambda-2$lambda-1(CopySpec it) {
        String[] stringArray = new String[]{"CHANGELOG.md", "README.md"};
        it.include(stringArray);
        it.into((Object)"META-INF");
    }

    private static final void resolutionStrategy$lambda-4$lambda-3(ResolutionStrategy rs) {
        rs.cacheChangingModulesFor(0, TimeUnit.SECONDS);
        rs.cacheDynamicVersionsFor(0, TimeUnit.SECONDS);
    }

    private static final void resolutionStrategy$lambda-4(Configuration conf) {
        conf.resolutionStrategy(JarConfigurer::resolutionStrategy$lambda-4$lambda-3);
    }

    private static final void configureRepos$lambda-10$lambda-7$lambda-6(String $repo, MavenArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)$repo, (String)"$repo");
        it.setUrl((Object)$repo);
    }

    private static final void configureRepos$lambda-10$lambda-9$lambda-8(String $repo, MavenArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)$repo, (String)"$repo");
        it.setUrl((Object)$repo);
    }

    private static final void configureRepos$lambda-10(Project $target, JarConfigurer this$0, Project it) {
        String repo;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JavaExtension javaExtension = (JavaExtension)$target.getExtensions().getByType(JavaExtension.class);
        Iterable iterable = javaExtension.getRepositories();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            repo = (String)element$iv;
            boolean bl = false;
            $target.getRepositories().maven(arg_0 -> JarConfigurer.configureRepos$lambda-10$lambda-7$lambda-6(repo, arg_0));
        }
        if (this$0.isDevelopmentBranch($target)) {
            $this$forEach$iv = javaExtension.getSnapshotsRepositories();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                repo = (String)element$iv;
                boolean bl = false;
                $target.getRepositories().maven(arg_0 -> JarConfigurer.configureRepos$lambda-10$lambda-9$lambda-8(repo, arg_0));
            }
        }
    }

    private static final void targetJavaVersion$lambda-15(Project $target, Project it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        JavaExtension javaExtension = (JavaExtension)$target.getExtensions().getByType(JavaExtension.class);
        Object object2 = $target.findProperty(javaExtension.getJvmVersionPropertyName());
        if (object2 == null) {
            object = null;
        } else {
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it2 = object3;
            boolean bl3 = false;
            String string = it2.toString();
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            bl4 = false;
            boolean bl5 = false;
            String version = string;
            boolean bl6 = false;
            object = JavaVersion.toVersion((Object)version);
        }
        Object object4 = object;
        JavaVersion targetJavaVersion = object4 == null ? JavaVersion.VERSION_1_8 : object4;
        object4 = $target.getExtensions().getByType(JavaPluginExtension.class);
        boolean bl = false;
        boolean bl7 = false;
        JavaPluginExtension $this$targetJavaVersion_u24lambda_u2d15_u24lambda_u2d13 = (JavaPluginExtension)object4;
        boolean bl8 = false;
        $this$targetJavaVersion_u24lambda_u2d15_u24lambda_u2d13.setSourceCompatibility(targetJavaVersion);
        $this$targetJavaVersion_u24lambda_u2d15_u24lambda_u2d13.setTargetCompatibility(targetJavaVersion);
        JavaVersion currentCompileJavaVersion = Jvm.current().getJavaVersion();
        if (currentCompileJavaVersion == null || currentCompileJavaVersion.isJava9Compatible()) {
            Task task = $target.getTasks().getByName("compileJava");
            if (task == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.compile.JavaCompile");
            }
            task = (JavaCompile)task;
            bl7 = false;
            boolean bl9 = false;
            Task $this$targetJavaVersion_u24lambda_u2d15_u24lambda_u2d14 = task;
            boolean bl10 = false;
            Object[] objectArray = new String[]{"--release", targetJavaVersion.getMajorVersion()};
            $this$targetJavaVersion_u24lambda_u2d15_u24lambda_u2d14.getOptions().getCompilerArgs().addAll(CollectionsKt.listOf((Object[])objectArray));
        }
    }
}

