/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.git;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/git/GitManager;", "Ljava/lang/AutoCloseable;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "git", "Lorg/eclipse/jgit/api/Git;", "branchFullName", "", "branchName", "close", "", "describe", "findCommonAncestor", "leftBranch", "rightBranch", "findModifiedFiles", "", "Ljava/io/File;", "head", "tail", "findRemoteBranch", "getCommitCount", "", "isDevBranch", "", "isDevelopmentBranch", "isHotfixBranch", "isMasterBranch", "isMasterOrDev", "isReleaseBranch", "isReleaseTag", "isStableBranch", "java-plugin"})
public final class GitManager
implements AutoCloseable {
    @NotNull
    private final Project project;
    @NotNull
    private final Git git;

    public GitManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.git = new Git(((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(this.project.getProjectDir())).build());
    }

    private final String describe() {
        return this.git.describe().setTags(true).call();
    }

    private final boolean isMasterBranch() {
        return StringsKt.equals((String)this.branchName(), (String)"master", (boolean)true);
    }

    private final boolean isDevBranch() {
        return StringsKt.equals((String)this.branchName(), (String)"dev", (boolean)true);
    }

    private final boolean isMasterOrDev() {
        return this.isMasterBranch() || this.isDevBranch();
    }

    private final boolean isReleaseBranch() {
        CharSequence charSequence = this.branchName();
        Regex regex = new Regex("(release)/.*");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    private final boolean isHotfixBranch() {
        CharSequence charSequence = this.branchName();
        Regex regex = new Regex("(hotfix)/.*");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    private final boolean isReleaseTag() {
        boolean bl;
        String string = this.describe();
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            CharSequence charSequence = string;
            Regex regex = new Regex("\\d+\\.\\d+\\.\\d+");
            boolean bl3 = false;
            bl = bl2 = regex.matches(charSequence);
        }
        return bl;
    }

    private final boolean isStableBranch() {
        return this.isMasterOrDev() || this.isReleaseBranch() || this.isHotfixBranch() || this.isReleaseTag();
    }

    public final boolean isDevelopmentBranch() {
        return !this.isStableBranch();
    }

    @NotNull
    public final String branchName() {
        String string = this.git.getRepository().getBranch();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"git.repository.branch");
        return string;
    }

    @NotNull
    public final String branchFullName() {
        CharSequence charSequence = this.branchName();
        Regex regex = new Regex("[^a-zA-Z0-9\\-\\.]+");
        String string = "-";
        boolean bl = false;
        return regex.replace(charSequence, string);
    }

    @Nullable
    public final String findRemoteBranch(@NotNull String branchName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            List list = this.git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"git.branchList().setList\u2026d.ListMode.REMOTE).call()");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Ref branch = (Ref)element$iv;
                boolean bl = false;
                if (!branchName.equals(this.git.getRepository().shortenRemoteBranchName(branch.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Ref ref = v0;
        return ref == null ? null : ref.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String findCommonAncestor(@NotNull String leftBranch, @NotNull String rightBranch) {
        Intrinsics.checkNotNullParameter((Object)leftBranch, (String)"leftBranch");
        Intrinsics.checkNotNullParameter((Object)rightBranch, (String)"rightBranch");
        AutoCloseable autoCloseable = (AutoCloseable)new RevWalk(this.git.getRepository());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            RevWalk revWalk = (RevWalk)autoCloseable;
            boolean bl3 = false;
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(leftBranch)));
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(rightBranch)));
            String string = revWalk.next().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"revWalk.next().name()");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCommitCount(@NotNull String head, @NotNull String tail) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        AutoCloseable autoCloseable = (AutoCloseable)new RevWalk(this.git.getRepository());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            RevWalk revWalk = (RevWalk)autoCloseable;
            boolean bl3 = false;
            int n = RevWalkUtils.count((RevWalk)revWalk, (RevCommit)revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(head)), (RevCommit)revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(tail)));
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"BC_BAD_CAST_TO_ABSTRACT_COLLECTION"})
    @NotNull
    public final List<File> findModifiedFiles(@NotNull String head, @NotNull String tail) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        AutoCloseable autoCloseable = (AutoCloseable)this.git.getRepository().newObjectReader();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            ObjectReader reader = (ObjectReader)autoCloseable;
            boolean bl3 = false;
            CanonicalTreeParser oldTree = new CanonicalTreeParser();
            CanonicalTreeParser newTree = new CanonicalTreeParser();
            oldTree.reset(reader, (AnyObjectId)this.git.getRepository().resolve(Intrinsics.stringPlus((String)tail, (Object)"^{tree}")));
            newTree.reset(reader, (AnyObjectId)this.git.getRepository().resolve(Intrinsics.stringPlus((String)head, (Object)"^{tree}")));
            List diffs = this.git.diff().setNewTree((AbstractTreeIterator)newTree).setOldTree((AbstractTreeIterator)oldTree).call();
            Intrinsics.checkNotNullExpressionValue((Object)diffs, (String)"diffs");
            Iterable $this$map$iv = diffs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DiffEntry diffEntry = (DiffEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Object object = this.project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.projectDir");
                File file = object;
                object = it.getNewPath();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.newPath");
                File file2 = FilesKt.resolve((File)file, (String)object);
                collection.add(file2);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void close() {
        this.git.close();
    }
}

