/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.checkstyle;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import ru.yoomoney.gradle.plugins.backend.build.staticanalysis.StaticAnalysisProperties;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/checkstyle/CheckCheckstyleTask;", "Lorg/gradle/api/DefaultTask;", "()V", "checkCheckstyle", "", "getCheckstyleLowerLimit", "", "limit", "logSuccess", "errorsCount", "updateIfLocalOrElseThrow", "staticAnalysis", "Lru/yoomoney/gradle/plugins/backend/build/staticanalysis/StaticAnalysisProperties;", "Companion", "java-plugin"})
public class CheckCheckstyleTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CHECKSTYLE_REPORT_FILE_NAME = "main.xml";

    @TaskAction
    public final void checkCheckstyle() {
        Integer checkstyleLimit;
        StaticAnalysisProperties staticAnalysis;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        StaticAnalysisProperties staticAnalysisProperties = staticAnalysis = StaticAnalysisProperties.Companion.load(project);
        Integer n = checkstyleLimit = staticAnalysisProperties == null ? null : staticAnalysisProperties.getProperty("checkstyle");
        if (checkstyleLimit == null) {
            this.getLogger().warn("skipping check checkstyle");
            return;
        }
        File reportsDir = ((CheckstyleExtension)this.getProject().getExtensions().getByType(CheckstyleExtension.class)).getReportsDir();
        Intrinsics.checkNotNullExpressionValue((Object)reportsDir, (String)"reportsDir");
        File checkStyleReport = FilesKt.resolve((File)reportsDir, (String)CHECKSTYLE_REPORT_FILE_NAME);
        if (!checkStyleReport.exists() || !checkStyleReport.isFile()) {
            this.getLogger().warn("Have not found " + reportsDir + "/main.xml, skipping check.");
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document checkStyleReportDoc = documentBuilderFactory.newDocumentBuilder().parse(checkStyleReport);
        int errorsCount = checkStyleReportDoc.getElementsByTagName("error").getLength();
        if (errorsCount > checkstyleLimit) {
            throw new GradleException("Too much checkstyle errors: actual=" + errorsCount + ", limit=" + checkstyleLimit);
        }
        if (errorsCount < this.getCheckstyleLowerLimit(checkstyleLimit)) {
            this.updateIfLocalOrElseThrow(staticAnalysis, errorsCount);
        } else {
            this.logSuccess(errorsCount);
        }
    }

    private final void updateIfLocalOrElseThrow(StaticAnalysisProperties staticAnalysis, int errorsCount) {
        if (this.getProject().hasProperty("ci")) {
            throw new GradleException("\u0421heckstyle limit is too high, must be " + errorsCount + ". Decrease it in file static-analysis.properties.");
        }
        staticAnalysis.setProperty("checkstyle", errorsCount);
        staticAnalysis.store();
        this.logSuccess(errorsCount);
    }

    private final void logSuccess(int errorsCount) {
        this.getLogger().lifecycle("Checkstyle check successfully passed with " + errorsCount + " errors");
    }

    private final int getCheckstyleLowerLimit(int limit) {
        return limit * 95 / 100;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/checkstyle/CheckCheckstyleTask$Companion;", "", "()V", "CHECKSTYLE_REPORT_FILE_NAME", "", "java-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

