/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build.checkstyle;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstyleReports;
import org.gradle.api.tasks.TaskCollection;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.backend.build.JavaExtension;
import ru.yoomoney.gradle.plugins.backend.build.checkstyle.CheckCheckstyleTask;
import ru.yoomoney.gradle.plugins.backend.build.git.GitManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/checkstyle/CheckCheckstyleConfigurer;", "", "()V", "checkstyleConfig", "", "checkstyleEnabled", "", "project", "Lorg/gradle/api/Project;", "gitManager", "Lru/yoomoney/gradle/plugins/backend/build/git/GitManager;", "configureCheckstyleExtensions", "", "init", "Companion", "java-plugin"})
public final class CheckCheckstyleConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_CHECKSTYLE_CONFIG = "/checkstyle.xml";

    public final void init(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.configureCheckstyleExtensions(project);
        project.getTasks().withType(Checkstyle.class, CheckCheckstyleConfigurer::init$lambda-1);
        GitManager gitManager = new GitManager(project);
        TaskCollection taskCollection = project.getTasks().withType(Checkstyle.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(Checkstyle::class.java)");
        Iterable $this$forEach$iv = (Iterable)taskCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Checkstyle task = (Checkstyle)element$iv;
            boolean bl = false;
            task.onlyIf(arg_0 -> CheckCheckstyleConfigurer.init$lambda-3$lambda-2(this, task, gitManager, arg_0));
        }
        CheckCheckstyleTask checkCheckstyleTask = (CheckCheckstyleTask)project.getTasks().create("checkCheckstyle", CheckCheckstyleTask.class);
        Object[] objectArray = new Object[]{checkCheckstyleTask};
        project.getTasks().getByName("checkstyleMain").finalizedBy(objectArray);
    }

    private final boolean checkstyleEnabled(Project project, GitManager gitManager) {
        JavaExtension javaModuleExtension = (JavaExtension)project.getExtensions().getByType(JavaExtension.class);
        if (javaModuleExtension.getAnalyseDevelopmentBranchesOnly() && !gitManager.isDevelopmentBranch()) {
            project.getLogger().warn("Checkstyle is enabled on feature/ and hotfix/ and bugfix/ branches. Skipping.");
            return false;
        }
        return javaModuleExtension.getCheckstyleEnabled();
    }

    private final void configureCheckstyleExtensions(Project project) {
        CheckstyleExtension checkstyleExtension = (CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class);
        checkstyleExtension.setToolVersion("7.3");
        checkstyleExtension.setSourceSets((Collection)CollectionsKt.listOf((Object)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getAt("main")));
        checkstyleExtension.setIgnoreFailures(true);
        checkstyleExtension.setReportsDir(project.file((Object)(project.getBuildDir() + "/checkstyleReports")));
        checkstyleExtension.setConfig(project.getResources().getText().fromString(this.checkstyleConfig()));
    }

    private final String checkstyleConfig() {
        InputStream inputStream = this.getClass().getResourceAsStream(DEFAULT_CHECKSTYLE_CONFIG);
        String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(inputStream, StandardCharsets.UTF_8)");
        return string;
    }

    private static final void init$lambda-1$lambda-0(CheckstyleReports reports) {
        reports.getXml().getRequired().set((Object)true);
        reports.getHtml().getRequired().set((Object)false);
    }

    private static final void init$lambda-1(Checkstyle it) {
        it.reports(CheckCheckstyleConfigurer::init$lambda-1$lambda-0);
    }

    private static final boolean init$lambda-3$lambda-2(CheckCheckstyleConfigurer this$0, Checkstyle $task, GitManager $gitManager, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gitManager, (String)"$gitManager");
        Project project = $task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
        return this$0.checkstyleEnabled(project, $gitManager);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/backend/build/checkstyle/CheckCheckstyleConfigurer$Companion;", "", "()V", "DEFAULT_CHECKSTYLE_CONFIG", "", "java-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

