/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.backend.build;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LIMITS_FILE_NAME", "", "getStaticAnalysisLimit", "Ljava/util/Optional;", "", "project", "Lorg/gradle/api/Project;", "limitName", "java-plugin"})
public final class GetStaticAnalysisLimitKt {
    @NotNull
    private static final String LIMITS_FILE_NAME = "static-analysis.properties";

    @NotNull
    public static final Optional<Integer> getStaticAnalysisLimit(@NotNull Project project, @NotNull String limitName) {
        Optional<Integer> optional;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)limitName, (String)"limitName");
        File limitsFile = project.file((Object)LIMITS_FILE_NAME);
        if (!limitsFile.exists() || !limitsFile.isFile()) {
            project.getLogger().warn("Have not found static-analysis.properties");
            Optional<Integer> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty()");
            return optional2;
        }
        Properties limits = new Properties();
        limits.load(Files.newInputStream(limitsFile.toPath(), new OpenOption[0]));
        String limitStr = limits.getProperty(limitName);
        if (limitStr == null) {
            project.getLogger().warn("Not found settings in " + limitsFile.getName() + " for: type=" + limitName);
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"{\n        project.logger\u2026   Optional.empty()\n    }");
            optional = optional3;
        } else {
            Optional<Integer> optional4 = Optional.of(Integer.valueOf(limitStr));
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"of(Integer.valueOf(limitStr))");
            optional = optional4;
        }
        return optional;
    }
}

