/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.javapublishing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusPublishPlugin;
import io.github.gradlenexus.publishplugin.NexusRepository;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.javapublishing.JavaArtifactPublishExtension;
import ru.yoomoney.gradle.plugins.javapublishing.PublicationAdditionalInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010 \u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0003J\f\u0010#\u001a\u00020$*\u00020\u0002H\u0002\u00a8\u0006&"}, d2={"Lru/yoomoney/gradle/plugins/javapublishing/JavaArtifactPublishPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "addAdditionalInfo", "", "artifactId", "", "additionalInfo", "Lru/yoomoney/gradle/plugins/javapublishing/PublicationAdditionalInfo;", "mavenPublication", "Lorg/gradle/api/publish/maven/MavenPublication;", "apply", "project", "configureJavadoc", "configurePublishing", "javaArtifactPublishExtension", "Lru/yoomoney/gradle/plugins/javapublishing/JavaArtifactPublishExtension;", "configureReleaseRepositories", "configureStagingRepositories", "configureStoreVersion", "getPublicationUrl", "baseUrl", "organizationId", "getPublishingComponent", "Lorg/gradle/api/component/SoftwareComponent;", "getScmConnectionUrl", "getScmDeveloperConnectionUrl", "getScmUrl", "signing", "target", "storeVersion", "storeVersionToFile", "versionDir", "content", "isSnapshot", "", "Companion", "java-artifact-publish-plugin"})
public final class JavaArtifactPublishPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String extensionName = "javaArtifactPublishSettings";
    @NotNull
    public static final String publicationName = "mainArtifact";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getPluginManager().apply(MavenPublishPlugin.class);
        JavaArtifactPublishExtension extension = (JavaArtifactPublishExtension)project.getExtensions().findByType(JavaArtifactPublishExtension.class);
        if (extension == null) {
            project.getExtensions().create(extensionName, JavaArtifactPublishExtension.class, new Object[0]);
        }
        PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        publishingExtension.getPublications().create(publicationName, MavenPublication.class);
        project.afterEvaluate(arg_0 -> JavaArtifactPublishPlugin.apply$lambda-0(project, this, arg_0));
    }

    private final void configureJavadoc(Project project) {
        Javadoc javadoc;
        Javadoc javadoc2 = javadoc = (Javadoc)project.getTasks().findByName("javadoc");
        Intrinsics.checkNotNull((Object)javadoc2);
        javadoc2.getOptions().setEncoding("UTF-8");
        javadoc.setFailOnError(false);
        project.getTasks().create("sourcesJar", Jar.class, arg_0 -> JavaArtifactPublishPlugin.configureJavadoc$lambda-1(project, arg_0));
        project.getTasks().create("javadocJar", Jar.class, arg_0 -> JavaArtifactPublishPlugin.configureJavadoc$lambda-2(javadoc, arg_0));
    }

    private final void configurePublishing(Project project, JavaArtifactPublishExtension javaArtifactPublishExtension) {
        PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        PublicationAdditionalInfo publicationAdditionalInfo = javaArtifactPublishExtension.getPublicationAdditionalInfo();
        publishingExtension.publications(arg_0 -> JavaArtifactPublishPlugin.configurePublishing$lambda-6(javaArtifactPublishExtension, this, project, publicationAdditionalInfo, arg_0));
        if (javaArtifactPublishExtension.getStaging().getEnabled()) {
            this.configureStagingRepositories(project, javaArtifactPublishExtension);
        } else {
            this.configureReleaseRepositories(project, javaArtifactPublishExtension);
        }
        TaskCollection taskCollection = project.getTasks().withType(PublishToMavenRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(P\u2026enRepository::class.java)");
        Iterable $this$forEach$iv = (Iterable)taskCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PublishToMavenRepository task = (PublishToMavenRepository)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{"jar", "test"};
            task.dependsOn(objectArray);
        }
    }

    private final void configureReleaseRepositories(Project project, JavaArtifactPublishExtension javaArtifactPublishExtension) {
        PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        publishingExtension.repositories(arg_0 -> JavaArtifactPublishPlugin.configureReleaseRepositories$lambda-10(this, project, javaArtifactPublishExtension, arg_0));
    }

    private final void configureStagingRepositories(Project project, JavaArtifactPublishExtension javaArtifactPublishExtension) {
        if (!project.getRootProject().equals(project)) {
            return;
        }
        project.getPluginManager().apply(NexusPublishPlugin.class);
        NexusPublishExtension nexusPublishingExtension = (NexusPublishExtension)project.getExtensions().getByType(NexusPublishExtension.class);
        nexusPublishingExtension.getPackageGroup().set((Object)javaArtifactPublishExtension.getGroupId());
        nexusPublishingExtension.getRepositories().create("maven", arg_0 -> JavaArtifactPublishPlugin.configureStagingRepositories$lambda-11(javaArtifactPublishExtension, arg_0));
    }

    private final boolean isSnapshot(Project $this$isSnapshot) {
        return StringsKt.endsWith$default((String)$this$isSnapshot.getProject().getVersion().toString(), (String)"-SNAPSHOT", (boolean)false, (int)2, null);
    }

    private final void signing(Project target) {
        target.getPluginManager().apply(SigningPlugin.class);
        SigningExtension signingExtension = (SigningExtension)target.getExtensions().getByType(SigningExtension.class);
        String signingKey = (String)target.property("signingKey");
        String signingPassword = (String)target.property("signingPassword");
        signingExtension.useInMemoryPgpKeys(signingKey, signingPassword);
        PublishingExtension publishingExtension = (PublishingExtension)target.getExtensions().getByType(PublishingExtension.class);
        Publication[] publicationArray = publishingExtension.getPublications().getByName(publicationName);
        if (publicationArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.publish.maven.MavenPublication");
        }
        MavenPublication mavenPublication = (MavenPublication)publicationArray;
        publicationArray = new Publication[]{(Publication)mavenPublication};
        signingExtension.sign(publicationArray);
    }

    private final void configureStoreVersion(Project project, JavaArtifactPublishExtension javaArtifactPublishExtension) {
        this.storeVersion(project, javaArtifactPublishExtension);
        Object[] objectArray = new Object[]{"storeVersion"};
        project.getTasks().getByName("publish").finalizedBy(objectArray);
    }

    private final void storeVersion(Project project, JavaArtifactPublishExtension javaArtifactPublishExtension) {
        Task storeVersion = project.getTasks().create("storeVersion");
        storeVersion.setDescription("Generates file, which contains information about build version");
        storeVersion.doLast(arg_0 -> JavaArtifactPublishPlugin.storeVersion$lambda-12(javaArtifactPublishExtension, project, this, arg_0));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private final void storeVersionToFile(Project project, String versionDir, String content) {
        try {
            String[] stringArray = new String[]{"version.txt"};
            Path versionFile = Paths.get(versionDir, stringArray);
            ResourceGroovyMethods.write((File)versionFile.toFile(), (String)content);
            project.getLogger().lifecycle(Intrinsics.stringPlus((String)"File with version generated successfully into ", (Object)versionFile));
        }
        catch (IOException e) {
            project.getLogger().lifecycle("Error occurred during storing version", (Throwable)e);
        }
    }

    private final SoftwareComponent getPublishingComponent(Project project, JavaArtifactPublishExtension javaArtifactPublishExtension) {
        return javaArtifactPublishExtension.getPublishingComponent() == null ? (SoftwareComponent)project.getComponents().getByName("java") : javaArtifactPublishExtension.getPublishingComponent();
    }

    private final void addAdditionalInfo(String artifactId, PublicationAdditionalInfo additionalInfo, MavenPublication mavenPublication) {
        String string = additionalInfo.getOrganizationUrl();
        Intrinsics.checkNotNull((Object)string);
        String host = new URI(string).getHost();
        String string2 = additionalInfo.getOrganizationUrl();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = new URI(string2).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"URI(additionalInfo.organizationUrl!!).path");
        String organizationId = StringsKt.replace$default((String)string3, (String)"/", (String)"", (boolean)false, (int)4, null);
        mavenPublication.pom(arg_0 -> JavaArtifactPublishPlugin.addAdditionalInfo$lambda-26(additionalInfo, artifactId, this, host, organizationId, arg_0));
    }

    private final String getScmConnectionUrl(String baseUrl, String organizationId, String artifactId) {
        return "scm:git:git://" + baseUrl + '/' + organizationId + '/' + artifactId + ".git";
    }

    private final String getScmDeveloperConnectionUrl(String baseUrl, String organizationId, String artifactId) {
        return "scm:git:ssh://" + baseUrl + ':' + organizationId + '/' + artifactId + ".git";
    }

    private final String getScmUrl(String baseUrl, String organizationId, String artifactId) {
        return "https://" + baseUrl + '/' + organizationId + '/' + artifactId + "/tree/master";
    }

    private final String getPublicationUrl(String baseUrl, String organizationId, String artifactId) {
        return "https://" + baseUrl + '/' + organizationId + '/' + artifactId;
    }

    private static final void apply$lambda-0(Project $project, JavaArtifactPublishPlugin this$0, Project target) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JavaArtifactPublishExtension artifactPublishExtension = (JavaArtifactPublishExtension)$project.getExtensions().getByType(JavaArtifactPublishExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
        this$0.configureJavadoc(target);
        Intrinsics.checkNotNullExpressionValue((Object)artifactPublishExtension, (String)"artifactPublishExtension");
        this$0.configurePublishing(target, artifactPublishExtension);
        if (artifactPublishExtension.getSigning() && !this$0.isSnapshot($project)) {
            this$0.signing(target);
        }
        this$0.configureStoreVersion(target, artifactPublishExtension);
    }

    private static final void configureJavadoc$lambda-1(Project $project, Jar sourcesJar) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        SourceDirectorySet sourceSet = ((SourceSet)((JavaPluginExtension)$project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getAllSource();
        Object[] objectArray = new String[]{"**/*.java", "**/*.kt", "**/*.kts"};
        sourceSet.getFilter().include((String[])objectArray);
        objectArray = new Object[]{sourceSet};
        sourcesJar.from(objectArray);
        sourcesJar.getArchiveClassifier().set((Object)"sources");
    }

    private static final void configureJavadoc$lambda-2(Javadoc $javadoc, Jar javadocJar) {
        Object[] objectArray = new Object[]{"javadoc"};
        javadocJar.dependsOn(objectArray);
        javadocJar.getArchiveClassifier().set((Object)"javadoc");
        objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)$javadoc.getDestinationDir());
        javadocJar.from(objectArray);
    }

    private static final void configurePublishing$lambda-6$lambda-5$lambda-3(VariantVersionMappingStrategy it) {
        it.fromResolutionOf("runtimeClasspath");
    }

    private static final void configurePublishing$lambda-6$lambda-5$lambda-4(VariantVersionMappingStrategy it) {
        it.fromResolutionResult();
    }

    private static final void configurePublishing$lambda-6$lambda-5(VersionMappingStrategy it) {
        it.usage("java-api", JavaArtifactPublishPlugin::configurePublishing$lambda-6$lambda-5$lambda-3);
        it.usage("java-runtime", JavaArtifactPublishPlugin::configurePublishing$lambda-6$lambda-5$lambda-4);
    }

    private static final void configurePublishing$lambda-6(JavaArtifactPublishExtension $javaArtifactPublishExtension, JavaArtifactPublishPlugin this$0, Project $project, PublicationAdditionalInfo $publicationAdditionalInfo, PublicationContainer publicationContainer) {
        Intrinsics.checkNotNullParameter((Object)$javaArtifactPublishExtension, (String)"$javaArtifactPublishExtension");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        MavenPublication mavenPublication = (MavenPublication)publicationContainer.maybeCreate(publicationName, MavenPublication.class);
        mavenPublication.setGroupId($javaArtifactPublishExtension.getGroupId());
        mavenPublication.setArtifactId($javaArtifactPublishExtension.getArtifactId());
        mavenPublication.from(this$0.getPublishingComponent($project, $javaArtifactPublishExtension));
        mavenPublication.artifact((Object)$project.getTasks().getByName("sourcesJar"));
        mavenPublication.artifact((Object)$project.getTasks().getByName("javadocJar"));
        mavenPublication.versionMapping(JavaArtifactPublishPlugin::configurePublishing$lambda-6$lambda-5);
        if ($publicationAdditionalInfo.getAddInfo()) {
            String string = $javaArtifactPublishExtension.getArtifactId();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)$publicationAdditionalInfo, (String)"publicationAdditionalInfo");
            Intrinsics.checkNotNullExpressionValue((Object)mavenPublication, (String)"mavenPublication");
            this$0.addAdditionalInfo(string, $publicationAdditionalInfo, mavenPublication);
        }
    }

    private static final void configureReleaseRepositories$lambda-10$lambda-9$lambda-8(JavaArtifactPublishExtension $javaArtifactPublishExtension, PasswordCredentials passwordCredentials) {
        Intrinsics.checkNotNullParameter((Object)$javaArtifactPublishExtension, (String)"$javaArtifactPublishExtension");
        passwordCredentials.setUsername($javaArtifactPublishExtension.getNexusUser());
        passwordCredentials.setPassword($javaArtifactPublishExtension.getNexusPassword());
    }

    private static final void configureReleaseRepositories$lambda-10$lambda-9(JavaArtifactPublishPlugin this$0, Project $project, JavaArtifactPublishExtension $javaArtifactPublishExtension, MavenArtifactRepository repository) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$javaArtifactPublishExtension, (String)"$javaArtifactPublishExtension");
        if (this$0.isSnapshot($project)) {
            String string = $javaArtifactPublishExtension.getSnapshotRepository();
            Intrinsics.checkNotNull((Object)string);
            repository.setUrl(URI.create(string));
        } else {
            String string = $javaArtifactPublishExtension.getReleaseRepository();
            Intrinsics.checkNotNull((Object)string);
            repository.setUrl(URI.create(string));
        }
        repository.credentials(arg_0 -> JavaArtifactPublishPlugin.configureReleaseRepositories$lambda-10$lambda-9$lambda-8($javaArtifactPublishExtension, arg_0));
    }

    private static final void configureReleaseRepositories$lambda-10(JavaArtifactPublishPlugin this$0, Project $project, JavaArtifactPublishExtension $javaArtifactPublishExtension, RepositoryHandler artifactRepositories) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$javaArtifactPublishExtension, (String)"$javaArtifactPublishExtension");
        artifactRepositories.maven(arg_0 -> JavaArtifactPublishPlugin.configureReleaseRepositories$lambda-10$lambda-9(this$0, $project, $javaArtifactPublishExtension, arg_0));
    }

    private static final void configureStagingRepositories$lambda-11(JavaArtifactPublishExtension $javaArtifactPublishExtension, NexusRepository nexusRepository) {
        Intrinsics.checkNotNullParameter((Object)$javaArtifactPublishExtension, (String)"$javaArtifactPublishExtension");
        Intrinsics.checkNotNullParameter((Object)nexusRepository, (String)"nexusRepository");
        Property property = nexusRepository.getNexusUrl();
        String string = $javaArtifactPublishExtension.getStaging().getNexusUrl();
        Intrinsics.checkNotNull((Object)string);
        property.set((Object)new URI(string));
        Property property2 = nexusRepository.getSnapshotRepositoryUrl();
        String string2 = $javaArtifactPublishExtension.getSnapshotRepository();
        Intrinsics.checkNotNull((Object)string2);
        property2.set((Object)new URI(string2));
        nexusRepository.getUsername().set((Object)System.getenv("NEXUS_USER"));
        nexusRepository.getPassword().set((Object)System.getenv("NEXUS_PASSWORD"));
    }

    private static final void storeVersion$lambda-12(JavaArtifactPublishExtension $javaArtifactPublishExtension, Project $project, JavaArtifactPublishPlugin this$0, Task $noName_0) {
        Intrinsics.checkNotNullParameter((Object)$javaArtifactPublishExtension, (String)"$javaArtifactPublishExtension");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = StringCompanionObject.INSTANCE;
        String string = "%s:%s:%s";
        Object[] objectArray = new Object[]{$javaArtifactPublishExtension.getGroupId(), $javaArtifactPublishExtension.getArtifactId(), $project.getVersion()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String version = string2;
        object = $project.getBuildDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.buildDir.absolutePath");
        this$0.storeVersionToFile($project, (String)object, version);
    }

    private static final void addAdditionalInfo$lambda-26$lambda-17$lambda-16(PublicationAdditionalInfo $additionalInfo, MavenPomLicense license) {
        Intrinsics.checkNotNullParameter((Object)$additionalInfo, (String)"$additionalInfo");
        PublicationAdditionalInfo.License license2 = $additionalInfo.getLicense();
        if (license2 != null) {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            PublicationAdditionalInfo.License license3 = license2;
            boolean bl3 = false;
            boolean bl4 = false;
            PublicationAdditionalInfo.License it2 = license3;
            boolean bl5 = false;
            String string2 = it2.getName();
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl6 = false;
                license.getName().set((Object)it);
            }
            string2 = it2.getUrl();
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl7 = false;
                license.getUrl().set((Object)it);
            }
        }
    }

    private static final void addAdditionalInfo$lambda-26$lambda-17(PublicationAdditionalInfo $additionalInfo, MavenPomLicenseSpec pomLicenseSpec) {
        Intrinsics.checkNotNullParameter((Object)$additionalInfo, (String)"$additionalInfo");
        pomLicenseSpec.license(arg_0 -> JavaArtifactPublishPlugin.addAdditionalInfo$lambda-26$lambda-17$lambda-16($additionalInfo, arg_0));
    }

    private static final void addAdditionalInfo$lambda-26$lambda-24$lambda-23$lambda-22(PublicationAdditionalInfo.Developer $it, MavenPomDeveloper developer) {
        String it;
        boolean bl;
        boolean bl2;
        String string;
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        String string2 = $it.getEmail();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl3 = false;
            developer.getEmail().set((Object)it);
        }
        string2 = $it.getName();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            developer.getName().set((Object)it);
        }
        string2 = $it.getOrganization();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl5 = false;
            developer.getOrganization().set((Object)it);
        }
        string2 = $it.getOrganizationUrl();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl6 = false;
            developer.getOrganizationUrl().set((Object)it);
        }
    }

    private static final void addAdditionalInfo$lambda-26$lambda-24(PublicationAdditionalInfo $additionalInfo, MavenPomDeveloperSpec pomDeveloperSpec) {
        Intrinsics.checkNotNullParameter((Object)$additionalInfo, (String)"$additionalInfo");
        ArrayList<PublicationAdditionalInfo.Developer> arrayList = $additionalInfo.getDevelopers();
        Intrinsics.checkNotNull(arrayList);
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PublicationAdditionalInfo.Developer it = (PublicationAdditionalInfo.Developer)element$iv;
            boolean bl = false;
            pomDeveloperSpec.developer(arg_0 -> JavaArtifactPublishPlugin.addAdditionalInfo$lambda-26$lambda-24$lambda-23$lambda-22(it, arg_0));
        }
    }

    private static final void addAdditionalInfo$lambda-26$lambda-25(JavaArtifactPublishPlugin this$0, String $host, String $organizationId, String $artifactId, MavenPomScm mavenPomScm) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$organizationId, (String)"$organizationId");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        Property property = mavenPomScm.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)$host, (String)"host");
        property.set((Object)this$0.getScmConnectionUrl($host, $organizationId, $artifactId));
        mavenPomScm.getDeveloperConnection().set((Object)this$0.getScmDeveloperConnectionUrl($host, $organizationId, $artifactId));
        mavenPomScm.getUrl().set((Object)this$0.getScmUrl($host, $organizationId, $artifactId));
    }

    private static final void addAdditionalInfo$lambda-26(PublicationAdditionalInfo $additionalInfo, String $artifactId, JavaArtifactPublishPlugin this$0, String $host, String $organizationId, MavenPom pomInfo) {
        Intrinsics.checkNotNullParameter((Object)$additionalInfo, (String)"$additionalInfo");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$organizationId, (String)"$organizationId");
        Property property = pomInfo.getDescription();
        String string = $additionalInfo.getDescription();
        Intrinsics.checkNotNull((Object)string);
        property.set((Object)string);
        pomInfo.setPackaging("jar");
        pomInfo.getName().set((Object)$artifactId);
        Property property2 = pomInfo.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)$host, (String)"host");
        property2.set((Object)this$0.getPublicationUrl($host, $organizationId, $artifactId));
        pomInfo.licenses(arg_0 -> JavaArtifactPublishPlugin.addAdditionalInfo$lambda-26$lambda-17($additionalInfo, arg_0));
        pomInfo.developers(arg_0 -> JavaArtifactPublishPlugin.addAdditionalInfo$lambda-26$lambda-24($additionalInfo, arg_0));
        pomInfo.scm(arg_0 -> JavaArtifactPublishPlugin.addAdditionalInfo$lambda-26$lambda-25(this$0, $host, $organizationId, $artifactId, arg_0));
        pomInfo.getDescription();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/yoomoney/gradle/plugins/javapublishing/JavaArtifactPublishPlugin$Companion;", "", "()V", "extensionName", "", "publicationName", "java-artifact-publish-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

