/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.showdependencies;

import groovy.json.JsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintActualDependenciesAction
implements Action<Project> {
    private static final Logger log = LoggerFactory.getLogger(PrintActualDependenciesAction.class);
    @Nonnull
    private final Set<String> includeGroupIdPrefixes;

    PrintActualDependenciesAction() {
        this(Collections.emptySet());
    }

    PrintActualDependenciesAction(@Nonnull Set<String> includeGroupIdPrefixes) {
        this.includeGroupIdPrefixes = Objects.requireNonNull(includeGroupIdPrefixes, "includeGroupIdPrefixes");
    }

    public void execute(Project project) {
        Collection configurations = project.getConfigurations().getAsMap().values();
        Collection buildscriptConfigurations = project.getBuildscript().getConfigurations().getAsMap().values();
        List allConfigurations = Stream.of(configurations, buildscriptConfigurations).flatMap(Collection::stream).collect(Collectors.toList());
        HashSet checked = new HashSet();
        ArrayList<Map<String, String>> dependencies = new ArrayList<Map<String, String>>();
        for (Configuration configuration : allConfigurations) {
            try {
                Set resolvedArtifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
                List moduleVersionIdentifiers = resolvedArtifacts.stream().map(ra -> ra.getModuleVersion().getId()).collect(Collectors.toList());
                Map<String, String> resolvedVersionMap = moduleVersionIdentifiers.stream().collect(Collectors.toMap(mvId -> mvId.getGroup() + ":" + mvId.getName(), ModuleVersionIdentifier::getVersion));
                configuration.getAllDependencies().forEach(dependency -> {
                    if (checked.contains(dependency)) {
                        return;
                    }
                    checked.add(dependency);
                    if (this.doNeedCheck((Dependency)dependency) && Objects.nonNull(dependency.getGroup())) {
                        HashMap<String, String> dep = new HashMap<String, String>();
                        dependencies.add(dep);
                        dep.put("scope", configuration.getName());
                        dep.put("group", dependency.getGroup());
                        dep.put("name", dependency.getName());
                        dep.put("version", (String)resolvedVersionMap.get(dependency.getGroup() + ":" + dependency.getName()));
                    }
                });
            }
            catch (IllegalStateException e) {
                log.info(String.format("The trouble with resolve configuration: configuration=%s", configuration.getName()), (Throwable)e);
            }
        }
        dependencies.sort(new DependencyComparator());
        JsonBuilder js = new JsonBuilder(dependencies);
        project.getLogger().lifecycle("{}", new Object[]{js.toPrettyString()});
        String fileName = this.includeGroupIdPrefixes.isEmpty() ? "actual_all_dependencies.json" : "actual_dependencies_by_group.json";
        File reportFile = new File(project.getBuildDir(), "report/dependencies/" + fileName);
        try {
            PrintActualDependenciesAction.writeToFile(js, reportFile);
        }
        catch (IOException exc) {
            log.warn("Unable to store actual dependencies", (Throwable)exc);
        }
    }

    private static void writeToFile(JsonBuilder js, File reportFile) throws IOException {
        if (!reportFile.getParentFile().exists() && reportFile.getParentFile().mkdirs()) {
            log.info("Report dir created");
        }
        if (reportFile.exists() && reportFile.delete()) {
            log.info("Existed report deleted");
        }
        try (OutputStream fos = Files.newOutputStream(reportFile.toPath(), new OpenOption[0]);){
            fos.write(js.toPrettyString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private boolean doNeedCheck(@Nonnull Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency");
        if (this.includeGroupIdPrefixes.isEmpty()) {
            return true;
        }
        return this.includeGroupIdPrefixes.stream().anyMatch(prefix -> dependency.getGroup() != null && dependency.getGroup().startsWith((String)prefix));
    }

    private static class DependencyComparator
    implements Comparator<Map<String, String>>,
    Serializable {
        private DependencyComparator() {
        }

        @Override
        public int compare(Map<String, String> dep1, Map<String, String> dep2) {
            int compareResult = dep1.get("scope").compareTo(dep2.get("scope"));
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = dep1.get("group").compareTo(dep2.get("group"));
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = dep1.get("name").compareTo(dep2.get("name"));
            return compareResult;
        }
    }
}

