/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.gradle.api.artifacts.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.ArtifactDependentPathsFinder;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.ConfigurationDependencies;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.FixedDependencies;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConflictedLibraryInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependency;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependent;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactNameSet;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.DependencyPath;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class ConfigurationConflictsAnalyzer {
    private final Logger log = LoggerFactory.getLogger(ConfigurationConflictsAnalyzer.class);
    private final ConfigurationDependencies dependencies;
    private final ArtifactNameSet fixedDependencies;

    public static ConfigurationConflictsAnalyzer create(@Nonnull FixedDependencies projectFixedDependencies, @Nonnull Configuration configuration) {
        ArtifactNameSet configurationFixedDependencies = projectFixedDependencies.forConfiguration(configuration);
        return new ConfigurationConflictsAnalyzer(configuration, configurationFixedDependencies);
    }

    private ConfigurationConflictsAnalyzer(@Nonnull Configuration configuration, @Nonnull ArtifactNameSet fixedDependencies) {
        this.dependencies = new ConfigurationDependencies(configuration);
        this.fixedDependencies = fixedDependencies;
    }

    public List<ConflictedLibraryInfo> findConflictedLibraries() {
        ArtifactNameSet requestedDependencies = this.getRequestedDependencies();
        return this.calculateConflictedLibraries(this.fixedDependencies, requestedDependencies);
    }

    private ArtifactNameSet getRequestedDependencies() {
        HashMap<LibraryName, Set<String>> requestedLibraryVersions = new HashMap<LibraryName, Set<String>>();
        for (ArtifactDependency artifact : this.dependencies.all()) {
            requestedLibraryVersions.computeIfAbsent(artifact.getRequestedLibraryName(), l -> new HashSet()).add(artifact.getRequestedVersion());
        }
        return ArtifactNameSet.fromLibraryVersions(requestedLibraryVersions);
    }

    private List<ConflictedLibraryInfo> calculateConflictedLibraries(@Nonnull ArtifactNameSet fixedDependencies, @Nonnull ArtifactNameSet requestedDependencies) {
        ArrayList<ConflictedLibraryInfo> conflictedLibraries = new ArrayList<ConflictedLibraryInfo>();
        requestedDependencies.forEach(artifact -> {
            String requestedVersion = artifact.getVersion();
            String fixedVersion = fixedDependencies.getVersions(artifact.getLibraryName()).stream().findFirst().orElse(null);
            if (fixedVersion == null || Objects.equals(fixedVersion, requestedVersion)) {
                return;
            }
            conflictedLibraries.add(this.createConflictInfo((ArtifactName)artifact, fixedVersion));
        });
        return conflictedLibraries;
    }

    private List<DependencyPath<ArtifactDependency>> findDependentPaths(ArtifactName requestedArtifactName) {
        ArtifactDependent<ArtifactDependency> root = this.dependencies.root();
        Predicate<ArtifactName> isRequested = artifactName -> artifactName.equals(requestedArtifactName);
        ArtifactDependentPathsFinder<ArtifactDependency> finder = new ArtifactDependentPathsFinder<ArtifactDependency>(root, isRequested);
        return finder.findPaths();
    }

    private ConflictedLibraryInfo createConflictInfo(ArtifactName requestedArtifact, String fixedVersion) {
        List<DependencyPath<ArtifactDependency>> conflictPaths = this.findDependentPaths(requestedArtifact);
        ConflictedLibraryInfo conflictedLibraryInfo = new ConflictedLibraryInfo(requestedArtifact, fixedVersion, conflictPaths);
        return conflictedLibraryInfo;
    }
}

