/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.analysis;

import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactNameSet;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class FixedDependencies {
    private final Map<String, ArtifactNameSet> configurationManagedDependencies;

    public static FixedDependencies from(Project project) {
        ManagedDependenciesLoader loader = new ManagedDependenciesLoader(project);
        Map<String, ArtifactNameSet> configurationManagedDependencies = project.getConfigurations().stream().collect(Collectors.toMap(Configuration::getName, loader::loadManagedDependencies));
        return new FixedDependencies(configurationManagedDependencies);
    }

    private FixedDependencies(Map<String, ArtifactNameSet> configurationManagedDependencies) {
        this.configurationManagedDependencies = configurationManagedDependencies;
    }

    public ArtifactNameSet forConfiguration(@Nonnull Configuration configuration) {
        return this.configurationManagedDependencies.get(configuration.getName());
    }

    private static class ManagedDependenciesLoader {
        private final Project project;

        private ManagedDependenciesLoader(Project project) {
            this.project = project;
        }

        ArtifactNameSet loadManagedDependencies(@Nonnull Configuration configuration) {
            return ArtifactNameSet.fromLibraryVersions(this.getManagedLibraries(configuration));
        }

        private Map<LibraryName, Set<String>> getManagedLibraries(@Nonnull Configuration configuration) {
            return this.getManagedLibraryVersions(configuration).entrySet().stream().collect(Collectors.toMap(entry -> LibraryName.parse((String)entry.getKey()), entry -> Collections.singleton((String)entry.getValue())));
        }

        private Map<String, String> getManagedLibraryVersions(@Nonnull Configuration configuration) {
            return this.getDependencyManagementExtension().getManagedVersionsForConfigurationHierarchy(configuration);
        }

        private DependencyManagementExtension getDependencyManagementExtension() {
            return (DependencyManagementExtension)this.project.getExtensions().getByType(DependencyManagementExtension.class);
        }
    }
}

