/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.analysis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependency;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependencyFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependent;

public class ConfigurationDependencies {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationDependencies.class);
    private final Configuration configuration;

    public ConfigurationDependencies(Configuration configuration) {
        this.configuration = configuration;
    }

    public ArtifactDependent<ArtifactDependency> root() {
        return this.getDependencyRoot();
    }

    public List<ArtifactDependency> all() {
        return this.findAllDependencies(this.configuration).stream().map(dependency -> ArtifactDependencyFactory.create(this.configuration, dependency)).filter(dependency -> dependency != null).collect(Collectors.toList());
    }

    private Set<? extends DependencyResult> findAllDependencies(@Nonnull Configuration configuration) {
        try {
            return configuration.getIncoming().getResolutionResult().getAllDependencies();
        }
        catch (Exception ex) {
            log.info("Failed to resolve dependencies of configuration {} with message: {}", (Object)configuration.getName(), (Object)ex.getMessage());
            return Collections.emptySet();
        }
    }

    private ArtifactDependent<ArtifactDependency> getDependencyRoot() {
        ResolvedComponentResult root = this.configuration.getIncoming().getResolutionResult().getRoot();
        return () -> root.getDependencies().stream().map(dependency -> ArtifactDependencyFactory.create(this.configuration, dependency)).filter(artifact -> artifact != null).collect(Collectors.toList());
    }
}

