/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class ArtifactVersionResolver {
    private final Logger log = LoggerFactory.getLogger(ArtifactVersionResolver.class);
    private static final Set<String> ILLEGAL_VERSION_PATTERNS = new HashSet<String>(Arrays.asList(".*alpha.*", ".*beta.*", ".*rc.*", ".*r\\d.*", ".*-b\\d.*", ".*sec.*"));
    @Nonnull
    private final Set<String> repoUrls;

    public ArtifactVersionResolver(@Nonnull Set<String> repoUrls) {
        this.repoUrls = Objects.requireNonNull(repoUrls, "repoUrls");
    }

    public Optional<String> getArtifactLatestVersion(String depGroup, String depName) {
        String path = depGroup.replace('.', '/');
        for (String repoUrl : this.repoUrls) {
            Optional<NodeList> versionsNodeList = this.getVersions(path, repoUrl, depName);
            if (!versionsNodeList.isPresent()) continue;
            return IntStream.range(0, versionsNodeList.get().getLength()).mapToObj(index -> ((NodeList)versionsNodeList.get()).item(index).getFirstChild().getNodeValue()).filter(ArtifactVersionResolver::isValidVersion).max(ArtifactVersionResolver::versionCompare);
        }
        return Optional.empty();
    }

    private static int versionCompare(String o1, String o2) {
        return VersionNumber.parse((String)o1).compareTo(VersionNumber.parse((String)o2));
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"})
    private Optional<NodeList> getVersions(String path, String repoUrl, String depName) {
        Document doc;
        try {
            String url = String.format("%s%s/%s/maven-metadata.xml", repoUrl, path, depName);
            String content = IOUtils.toString((InputStream)new URL(url).openStream(), (String)StandardCharsets.UTF_8.name());
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
            doc = documentBuilder.parse(IOUtils.toInputStream((String)content));
        }
        catch (Exception e) {
            this.log.info("Can't get or parse maven-metadata.xml, will try next repository: repository={}, dependency={}", (Object)repoUrl, (Object)depName);
            return Optional.empty();
        }
        doc.getDocumentElement().normalize();
        return Optional.of(doc.getElementsByTagName("version"));
    }

    private static boolean isValidVersion(String version) {
        String lowerName = version.toLowerCase();
        return !ILLEGAL_VERSION_PATTERNS.stream().anyMatch(pattern -> lowerName.matches((String)pattern));
    }
}

