/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether;

import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class LoggedTransferListener
extends AbstractTransferListener {
    private final Logger log = Logging.getLogger(LoggedTransferListener.class);

    LoggedTransferListener() {
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.log.info("{}: {}", (Object)message, (Object)LoggedTransferListener.getResource(event));
    }

    public void transferSucceeded(TransferEvent event) {
        this.log.info("Transfer succeeded: {}", (Object)LoggedTransferListener.getResource(event));
    }

    public void transferFailed(TransferEvent event) {
        this.log.info("Transfer failed: {}, error={}", (Object)LoggedTransferListener.getResource(event), (Object)LoggedTransferListener.getErrorMessage(event));
    }

    public void transferCorrupted(TransferEvent event) {
        this.log.info("Transfer corrupted: {}, error={}", (Object)LoggedTransferListener.getResource(event), (Object)LoggedTransferListener.getErrorMessage(event));
    }

    private static String getResource(TransferEvent event) {
        return event.getResource().getRepositoryUrl() + event.getResource().getResourceName();
    }

    private static String getErrorMessage(TransferEvent event) {
        return event.getException().getMessage();
    }
}

