/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether;

import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class LoggedRepositoryListener
extends AbstractRepositoryListener {
    private final Logger log = Logging.getLogger(LoggedRepositoryListener.class);

    LoggedRepositoryListener() {
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.log.info("Invalid artifact descriptor for {}: {}", (Object)event.getArtifact(), (Object)event.getException().getMessage());
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.log.info("Missing artifact descriptor for {}", (Object)event.getArtifact());
    }

    public void artifactResolved(RepositoryEvent event) {
        this.log.info("Resolved artifact {} from {}", (Object)event.getArtifact(), (Object)event.getRepository());
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.log.info("Downloading artifact {} from {}", (Object)event.getArtifact(), (Object)event.getRepository());
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.log.info("Downloaded artifact {} from {}", (Object)event.getArtifact(), (Object)event.getRepository());
    }

    public void artifactResolving(RepositoryEvent event) {
        this.log.info("Resolving artifact {}", (Object)event.getArtifact());
    }

    public void metadataInvalid(RepositoryEvent event) {
        this.log.info("Invalid metadata {}", (Object)event.getMetadata());
    }

    public void metadataResolved(RepositoryEvent event) {
        this.log.info("Resolved metadata {} from {}", (Object)event.getMetadata(), (Object)event.getRepository());
    }

    public void metadataResolving(RepositoryEvent event) {
        this.log.info("Resolving metadata {} from {}", (Object)event.getMetadata(), (Object)event.getRepository());
    }
}

