/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether;

import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.TransferListener;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether.LoggedRepositoryListener;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether.LoggedTransferListener;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether.ManualRepositorySystemFactory;

class AetherService {
    private static final String TEMP_DIRECTORY = System.getProperty("java.io.tmpdir");

    private AetherService() {
    }

    static RepositorySystem newRepositorySystem() {
        return ManualRepositorySystemFactory.newRepositorySystem();
    }

    static RepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(AetherService.generateLocalCachePath());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        session.setTransferListener((TransferListener)new LoggedTransferListener());
        session.setRepositoryListener((RepositoryListener)new LoggedRepositoryListener());
        return session;
    }

    static List<RemoteRepository> createRemoteRepositories(List<String> repositoryUrls) {
        int[] id = new int[]{0};
        return repositoryUrls.stream().map(url -> {
            int n = id[0];
            id[0] = n + 1;
            return new RemoteRepository.Builder(Integer.toString(n), "default", url).build();
        }).collect(Collectors.toList());
    }

    private static String generateLocalCachePath() {
        return Paths.get(TEMP_DIRECTORY, UUID.randomUUID().toString()).toString();
    }
}

