/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.Repository;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether.AetherService;

public class AetherRepository
implements Repository {
    private static final String ALL_LIBRARY_VERSIONS_REQUEST_FORMAT = "%s:%s:[0,)";
    private static final String ARTIFACT_DIRECT_DEPENDENCIES_REQUEST_FORMAT = "%s:%s:%s";
    private static final Logger log = Logging.getLogger(AetherRepository.class);
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    public static Repository create(List<String> repositoryUrls) {
        RepositorySystem repositorySystem = AetherService.newRepositorySystem();
        RepositorySystemSession session = AetherService.newRepositorySystemSession(repositorySystem);
        List<RemoteRepository> repositories = AetherService.createRemoteRepositories(repositoryUrls);
        return new AetherRepository(repositorySystem, session, repositories);
    }

    private AetherRepository(RepositorySystem repositorySystem, RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.repositorySystem = repositorySystem;
        this.session = session;
        this.repositories = repositories;
    }

    @Override
    public List<String> findVersions(LibraryName libraryName) {
        VersionRangeRequest request = this.createVersionRangeRequest(libraryName);
        VersionRangeResult result = null;
        try {
            result = this.repositorySystem.resolveVersionRange(this.session, request);
        }
        catch (VersionRangeResolutionException e) {
            log.warn("Version request failed: {}, {}", (Object)e.getResult(), (Object)e.getMessage());
        }
        return result != null ? result.getVersions().stream().map(Version::toString).collect(Collectors.toList()) : Collections.emptyList();
    }

    private VersionRangeRequest createVersionRangeRequest(LibraryName libraryName) {
        DefaultArtifact artifact = new DefaultArtifact(this.getVersionsRequestString(libraryName));
        VersionRangeRequest request = new VersionRangeRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.repositories);
        return request;
    }

    private String getVersionsRequestString(LibraryName libraryName) {
        return String.format(ALL_LIBRARY_VERSIONS_REQUEST_FORMAT, libraryName.getGroup(), libraryName.getName());
    }

    @Override
    public List<ArtifactName> findDirectDependencies(ArtifactName artifactName) {
        ArtifactDescriptorRequest request = this.createDirectDependenciesRequest(artifactName);
        ArtifactDescriptorResult result = null;
        try {
            result = this.repositorySystem.readArtifactDescriptor(this.session, request);
        }
        catch (ArtifactDescriptorException e) {
            log.debug("Failed to obtain artifact dependencies: request={}", (Object)request);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result.getDependencies().stream().map(Dependency::getArtifact).map(artifact -> new ArtifactName(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())).collect(Collectors.toList());
    }

    private ArtifactDescriptorRequest createDirectDependenciesRequest(ArtifactName artifactName) {
        DefaultArtifact artifact = new DefaultArtifact(AetherRepository.formatArtifactName(artifactName));
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.repositories);
        return request;
    }

    private static String formatArtifactName(ArtifactName artifactName) {
        LibraryName libraryName = artifactName.getLibraryName();
        return String.format(ARTIFACT_DIRECT_DEPENDENCIES_REQUEST_FORMAT, libraryName.getGroup(), libraryName.getName(), artifactName.getVersion());
    }
}

