/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.reporters;

import java.util.Collection;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRule;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.NameFormatter;

public class StaleExclusionsReporter {
    private static final String HEADER = "There are some stale exclusions.";
    private final Collection<String> messages;

    public StaleExclusionsReporter(Collection<String> messages) {
        this.messages = messages;
    }

    public void report(Iterable<ExclusionRule> exclusionRules) {
        this.messages.add(HEADER);
        exclusionRules.forEach(exclusionRule -> this.messages.add(StaleExclusionsReporter.formatExclusionRule(exclusionRule)));
    }

    private static String formatExclusionRule(ExclusionRule exclusionRule) {
        return String.format("   --- %-50s: %s -> %s", NameFormatter.format(exclusionRule.getLibrary()), exclusionRule.getRequestedVersion(), exclusionRule.getFixedVersion());
    }
}

