/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.reporters;

import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependency;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.NameFormatter;

class DependencyFormatter {
    private final ArtifactDependency dependency;
    private final LibraryName requestedLibraryName;
    private final String requestedVersion;
    private final LibraryName selectedLibraryName;
    private final String selectedVersion;

    static String format(ArtifactDependency dependency) {
        return new DependencyFormatter(dependency).formatArtifactDependency();
    }

    private DependencyFormatter(ArtifactDependency dependency) {
        this.dependency = dependency;
        this.requestedLibraryName = dependency.getRequestedLibraryName();
        this.requestedVersion = dependency.getRequestedVersion();
        this.selectedLibraryName = dependency.getSelectedLibraryName();
        this.selectedVersion = dependency.getSelectedVersion();
    }

    private String formatArtifactDependency() {
        if (this.hasSameLibraryNames()) {
            if (this.hasSameVersions()) {
                return this.formatArtifactName(new ArtifactName(this.requestedLibraryName, this.requestedVersion));
            }
            return String.format("%s:%s -> %s", this.formatLibraryName(this.requestedLibraryName), this.requestedVersion, this.selectedVersion);
        }
        return String.format("%s -> %s", this.formatArtifactName(this.dependency.getRequestedArtifactName()), this.formatArtifactName(this.dependency.getSelectedArtifactName()));
    }

    private String formatLibraryName(LibraryName libraryName) {
        return NameFormatter.format(libraryName);
    }

    private String formatArtifactName(ArtifactName artifactName) {
        return NameFormatter.format(artifactName);
    }

    private boolean hasSameLibraryNames() {
        return this.requestedLibraryName.equals(this.selectedLibraryName);
    }

    private boolean hasSameVersions() {
        return this.requestedVersion.equals(this.selectedVersion);
    }
}

