/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.reporters;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.gradle.api.artifacts.Configuration;
import org.gradle.util.VersionNumber;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConflictedLibraryInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.ConflictPathResolutionResult;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependency;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.DependencyPath;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.DependencyFormatter;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.NameFormatter;

public class ConflictedLibrariesReporter {
    private static final int MAX_INDENT_LEVEL = 10;
    private static final String[] INDENTS = ConflictedLibrariesReporter.createIndents(10);
    private static final String ERROR_CONFLICTED_DEPENDENCIES_MSG = "Versions conflict used libraries with fixed platform libraries.";
    private final Collection<String> messages;
    private boolean isHeaderAdded;

    public ConflictedLibrariesReporter(@Nonnull Collection<String> messages) {
        Objects.nonNull(messages);
        this.messages = messages;
    }

    public void report(Configuration configuration, Iterable<ConflictedLibraryInfo> conflictedLibraries) {
        this.addHeaderIfNecessary();
        this.addConfigurationSection(String.format("%s - %s", configuration.getName(), configuration.getDescription()));
        conflictedLibraries.forEach(conflict -> this.addConflictSection((ConflictedLibraryInfo)conflict, 1));
        this.addEmptyMessage();
    }

    private void addHeaderIfNecessary() {
        if (!this.isHeaderAdded) {
            this.addMessage(ERROR_CONFLICTED_DEPENDENCIES_MSG);
            this.isHeaderAdded = true;
        }
    }

    private void addConfigurationSection(String configuration) {
        if (!this.messages.isEmpty()) {
            this.addEmptyMessage();
        }
        this.addMessage(configuration);
    }

    private void addConflictSection(ConflictedLibraryInfo conflictedLibraryInfo, int indent) {
        this.addConflictHeader(conflictedLibraryInfo, indent);
        conflictedLibraryInfo.getConflictDependentPaths().forEach(conflictPath -> {
            ConflictPathResolutionResult resolutionResult = conflictedLibraryInfo.getResolutionFor((DependencyPath<ArtifactDependency>)conflictPath);
            this.addConflictPath((Iterable<ArtifactDependency>)conflictPath, resolutionResult, indent + 1);
        });
        this.addEmptyMessage();
    }

    private void addConflictHeader(ConflictedLibraryInfo conflictedLibraryInfo, int indent) {
        String message = String.format("--- %-50s: %s -> %s", NameFormatter.format(conflictedLibraryInfo.getLibrary()), conflictedLibraryInfo.getVersion(), conflictedLibraryInfo.getFixedVersion());
        this.addMessage(message, indent);
    }

    private void addConflictPath(Iterable<ArtifactDependency> conflictPath, ConflictPathResolutionResult resolutionResult, int indent) {
        this.addMessage(this.getDependencyPathString(conflictPath), indent);
        this.addResolutionResult(resolutionResult, indent + 1);
    }

    private void addResolutionResult(ConflictPathResolutionResult resolutionResult, int indent) {
        ArtifactName directDependency = resolutionResult.getDirectDependency();
        if (resolutionResult.getSuggestedVersions().isEmpty()) {
            String message = String.format("NO SOLUTIONS FOUND for %s with versions:", NameFormatter.format(directDependency.getLibraryName()));
            this.addMessage(message, indent);
            Set<String> checkedVersions = resolutionResult.getCheckedVersions();
            this.addMessage(checkedVersions.isEmpty() ? "[no any versions were analyzed]" : ConflictedLibrariesReporter.getSortedVersions(checkedVersions), indent + 1);
            return;
        }
        String suggestedVersionsHeader = String.format("TRY TO CHANGE VERSION OF %s FROM %s to one of the proposed:", NameFormatter.format(directDependency.getLibraryName()), directDependency.getVersion());
        this.addMessage(suggestedVersionsHeader, indent);
        this.addMessage(ConflictedLibrariesReporter.getSortedVersions(resolutionResult.getSuggestedVersions()), indent + 1);
    }

    private static Collection<String> getSortedVersions(Set<String> versions) {
        TreeSet versionNumbers = new TreeSet();
        versions.stream().map(VersionNumber::parse).forEach(versionNumbers::add);
        return versionNumbers.stream().map(VersionNumber::toString).collect(Collectors.toList());
    }

    private String getDependencyPathString(Iterable<ArtifactDependency> dependencyPath) {
        return "--> " + StreamSupport.stream(dependencyPath.spliterator(), false).map(dependency -> String.format("(%s)", DependencyFormatter.format(dependency))).reduce((dep1, dep2) -> dep1 + " --> " + dep2).orElse("");
    }

    private void addEmptyMessage() {
        this.addMessage("");
    }

    private void addMessage(Object message) {
        this.addMessage(message, 0);
    }

    private void addMessage(Object message, int indentLevel) {
        this.messages.add(INDENTS[indentLevel] + message);
    }

    private static String[] createIndents(int maxIndentLevel) {
        return (String[])IntStream.range(0, maxIndentLevel + 1).boxed().map(ConflictedLibrariesReporter::createIndent).toArray(String[]::new);
    }

    private static String createIndent(int indentLevel) {
        return String.join((CharSequence)"", Collections.nCopies(indentLevel, "    "));
    }
}

