/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import java.util.List;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ConflictRegister;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRule;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesStorage;

public class StaleExclusionsDetector
implements ConflictRegister {
    private final List<ExclusionRule> staleExclusionRules;

    public static StaleExclusionsDetector create(ExclusionsRulesStorage rulesStorage) {
        List<ExclusionRule> exclusionRules = rulesStorage.getExclusionRules();
        return new StaleExclusionsDetector(exclusionRules);
    }

    private StaleExclusionsDetector(List<ExclusionRule> staleExclusionRules) {
        this.staleExclusionRules = staleExclusionRules;
    }

    @Override
    public void registerConflict(ArtifactName requestedArtifact, String fixedVersion) {
        this.staleExclusionRules.remove(new ExclusionRule(requestedArtifact, fixedVersion));
    }

    public boolean hasStaleExclusions() {
        return this.staleExclusionRules.size() > 0;
    }

    public Iterable<ExclusionRule> getStaleExclusions() {
        return this.staleExclusionRules;
    }
}

