/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRule;

public class ExclusionsRulesStorage {
    private final Map<ArtifactName, Set<String>> rules = new HashMap<ArtifactName, Set<String>>();

    void registerExclusionRules(@Nonnull Set<ExclusionRule> exclusionRules) {
        exclusionRules.forEach(this::registerExclusionRule);
    }

    private void registerExclusionRule(@Nonnull ExclusionRule exclusionRule) {
        ArtifactName targetArtifactName = new ArtifactName(exclusionRule.getLibrary(), exclusionRule.getFixedVersion());
        this.rules.computeIfAbsent(targetArtifactName, version -> new HashSet()).add(exclusionRule.getRequestedVersion());
    }

    public Set<String> getAllowedRequestedVersions(@Nonnull LibraryName requestedLibrary, @Nonnull String targetVersion) {
        ArtifactName requestedArtifactName = new ArtifactName(requestedLibrary, targetVersion);
        return this.rules.get(requestedArtifactName);
    }

    List<ExclusionRule> getExclusionRules() {
        return this.rules.entrySet().stream().flatMap(entry -> this.getExclusionRules((ArtifactName)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toList());
    }

    private Stream<ExclusionRule> getExclusionRules(@Nonnull ArtifactName artifact, @Nonnull Set<String> allowedRequestedVersion) {
        LibraryName library = artifact.getLibraryName();
        String fixedVersion = artifact.getVersion();
        return allowedRequestedVersion.stream().map(version -> new ExclusionRule(library, (String)version, fixedVersion));
    }

    public String toString() {
        return this.rules.toString();
    }
}

