/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRule;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRulesParser;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesStorage;

abstract class ExclusionsRulesPropertiesReader {
    private final Logger log = LoggerFactory.getLogger(ExclusionsRulesPropertiesReader.class);

    ExclusionsRulesPropertiesReader() {
    }

    public abstract void loadTo(@Nonnull ExclusionsRulesStorage var1);

    void load(@Nonnull ExclusionsRulesStorage rulesStorage, @Nonnull InputStream exclusionRulesInputStream) {
        ExclusionRulesParser exclusionRulesParser = new ExclusionRulesParser();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(exclusionRulesInputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (ExclusionsRulesPropertiesReader.isNullOrEmpty(line = line.replaceAll("\\s+", "")) || ExclusionsRulesPropertiesReader.isComment(line)) continue;
                Set<ExclusionRule> rules = exclusionRulesParser.parseFrom(line);
                rulesStorage.registerExclusionRules(rules);
            }
        }
        catch (IOException e) {
            this.log.warn("Cannot load dependencies resolutions rules", (Throwable)e);
        }
    }

    private static boolean isComment(String line) {
        return line.startsWith("#");
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

