/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesPropertiesReader;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesStorage;

public class ExclusionsRulesPackageReader
extends ExclusionsRulesPropertiesReader {
    private final Logger log = LoggerFactory.getLogger(ExclusionsRulesPackageReader.class);
    private final Project project;
    private final String artifact;
    private final String exclusionFileName;

    ExclusionsRulesPackageReader(@Nonnull Project project, @Nonnull String artifact, @Nonnull String exclusionFileName) {
        this.project = project;
        this.artifact = artifact;
        this.exclusionFileName = exclusionFileName;
    }

    @Nullable
    private File findFileInArtifact(@Nonnull Configuration configuration, @Nonnull String artifact, @Nonnull String fileName) {
        File artifactFile = ExclusionsRulesPackageReader.findArtifactFile(configuration, artifact);
        return artifactFile != null ? this.findFileInZip(artifactFile, fileName) : null;
    }

    @Nullable
    private static File findArtifactFile(@Nonnull Configuration configuration, @Nonnull String artifact) {
        Set artifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
        for (ResolvedArtifact requestedArtifact : artifacts) {
            String artifactId = requestedArtifact.getId().getComponentIdentifier().getDisplayName();
            if (!artifactId.startsWith(artifact)) continue;
            return requestedArtifact.getFile();
        }
        return null;
    }

    @Nullable
    private File findFileInZip(@Nonnull File zipFile, @Nonnull String fileName) {
        FileTree files = this.project.zipTree((Object)zipFile);
        FileCollection filteredFiles = files.filter(element -> Objects.equals(element.getName(), fileName));
        return filteredFiles.getSingleFile();
    }

    @Override
    public void loadTo(@Nonnull ExclusionsRulesStorage rulesStorage) {
        for (Configuration configuration : this.project.getBuildscript().getConfigurations()) {
            File rulesFile = this.findFileInArtifact(configuration, this.artifact, this.exclusionFileName);
            if (rulesFile != null) {
                try (InputStream fileInputStream = Files.newInputStream(rulesFile.toPath(), new OpenOption[0]);){
                    this.load(rulesStorage, fileInputStream);
                }
                catch (FileNotFoundException e) {
                    this.log.warn("Cannot find file with upgrade versions rules.", (Throwable)e);
                }
                catch (IOException e) {
                    this.log.warn("Cannot loadTo file with upgrade versions rules.", (Throwable)e);
                }
                continue;
            }
            this.log.warn("Cannot find rules file \"{}\" with upgrade versions rules in specified artifact \"{}\" for configuration \"{}\".", new Object[]{this.exclusionFileName, this.artifact, configuration.getName()});
        }
    }
}

