/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesPropertiesReader;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesStorage;

public class ExclusionsRulesFileReader
extends ExclusionsRulesPropertiesReader {
    private final Logger log = LoggerFactory.getLogger(ExclusionsRulesFileReader.class);
    private final String absoluteFilePath;

    ExclusionsRulesFileReader(@Nonnull String absoluteFilePath) {
        this.absoluteFilePath = absoluteFilePath;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public void loadTo(@Nonnull ExclusionsRulesStorage rulesStorage) {
        Path fileNamePath = Paths.get(this.absoluteFilePath, new String[0]);
        if (!Files.isReadable(fileNamePath)) {
            this.log.warn("Cannot read file \"{}\" with upgrade versions rules.", (Object)fileNamePath.toAbsolutePath());
            return;
        }
        try (InputStream fileInputStream = Files.newInputStream(fileNamePath, new OpenOption[0]);){
            this.load(rulesStorage, fileInputStream);
        }
        catch (FileNotFoundException e) {
            this.log.warn("Cannot find file with upgrade versions rules.", (Throwable)e);
        }
        catch (IOException e) {
            this.log.warn("Cannot loadTo file with upgrade versions rules.", (Throwable)e);
        }
    }
}

