/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRule;

class ExclusionRulesParser {
    private final Logger log = LoggerFactory.getLogger(ExclusionRulesParser.class);
    private static final Pattern EXCLUSION_RULE_PATTERN = Pattern.compile("(?<library>.+)=(?<requestedVersions>.+)->(?<targetVersion>.+)");

    ExclusionRulesParser() {
    }

    @SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"})
    Set<ExclusionRule> parseFrom(String exclusionRules) {
        Matcher matcher = EXCLUSION_RULE_PATTERN.matcher(exclusionRules);
        if (!matcher.matches()) {
            this.log.warn("Wrong value format of versions rule: {}", (Object)exclusionRules);
            return Collections.emptySet();
        }
        LibraryName library = this.parseLibraryName(matcher.group("library"));
        if (library == null) {
            this.log.warn("Wrong key format of library name. library={}", (Object)matcher.group("library"));
            return Collections.emptySet();
        }
        String[] requestedVersions = matcher.group("requestedVersions").split(",");
        String targetVersion = matcher.group("targetVersion");
        return Arrays.stream(requestedVersions).map(requestedVersion -> new ExclusionRule(library, (String)requestedVersion, targetVersion)).collect(Collectors.toSet());
    }

    @Nullable
    private LibraryName parseLibraryName(@Nonnull String library) {
        try {
            return LibraryName.parse(library);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Failed to parse library name as <group>:<name>. Try to parse as <group>.<name>. library={}", (Object)library);
            int artifactIndex = library.lastIndexOf(46);
            if (artifactIndex == -1) {
                return null;
            }
            String group = library.substring(0, artifactIndex);
            String artifact = library.substring(artifactIndex + 1);
            return new LibraryName(group, artifact);
        }
    }
}

