/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import java.util.List;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesFileReader;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesPackageReader;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesPropertiesReader;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionsRulesStorage;

public class ExclusionRulesLoader {
    private final ExclusionsRulesStorage localExclusionRules = new ExclusionsRulesStorage();
    private final ExclusionsRulesStorage totalExclusionRules = new ExclusionsRulesStorage();

    public ExclusionsRulesStorage getLocalExclusionRules() {
        return this.localExclusionRules;
    }

    public ExclusionsRulesStorage getTotalExclusionRules() {
        return this.totalExclusionRules;
    }

    public void load(Project project, List<String> exclusionsSources) {
        for (String exclusionSource : exclusionsSources) {
            this.load(project, exclusionSource);
        }
    }

    private void load(Project project, String exclusionSource) {
        if (ExclusionRulesLoader.isMavenArtifact(exclusionSource, project)) {
            ExclusionsRulesPackageReader reader = new ExclusionsRulesPackageReader(project, exclusionSource, "libraries-versions-exclusions.properties");
            ((ExclusionsRulesPropertiesReader)reader).loadTo(this.totalExclusionRules);
        } else {
            ExclusionsRulesFileReader reader = new ExclusionsRulesFileReader(project.file((Object)exclusionSource).getAbsolutePath());
            ((ExclusionsRulesPropertiesReader)reader).loadTo(this.localExclusionRules);
            ((ExclusionsRulesPropertiesReader)reader).loadTo(this.totalExclusionRules);
        }
    }

    private static boolean isMavenArtifact(@Nonnull String name, Project project) {
        try {
            return !project.file((Object)name).exists();
        }
        catch (Exception e) {
            return true;
        }
    }
}

