/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.exclusions;

import java.util.Objects;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public final class ExclusionRule {
    private final LibraryName library;
    private final String requestedVersion;
    private final String fixedVersion;

    ExclusionRule(ArtifactName requestedArtifact, String fixedVersion) {
        this(requestedArtifact.getLibraryName(), requestedArtifact.getVersion(), fixedVersion);
    }

    ExclusionRule(LibraryName library, String requestedVersion, String fixedVersion) {
        this.library = library;
        this.requestedVersion = requestedVersion;
        this.fixedVersion = fixedVersion;
    }

    public LibraryName getLibrary() {
        return this.library;
    }

    public String getRequestedVersion() {
        return this.requestedVersion;
    }

    public String getFixedVersion() {
        return this.fixedVersion;
    }

    public int hashCode() {
        return 7 * this.library.hashCode() + 5 * this.requestedVersion.hashCode() + this.fixedVersion.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExclusionRule)) {
            return false;
        }
        ExclusionRule other = (ExclusionRule)obj;
        return Objects.equals(this.library, other.library) && Objects.equals(this.requestedVersion, other.requestedVersion) && Objects.equals(this.fixedVersion, other.fixedVersion);
    }
}

