/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.dsl;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.NameFormatter;

public class VersionSelectors {
    private static final Predicate<String> NO_VERSION_SELECTOR = version -> false;
    private final Map<String, Predicate<String>> libraryVersionSelectors = new HashMap<String, Predicate<String>>();

    public VersionSelectors(Map<String, Closure<Boolean>> libraryVersionSelectors) {
        libraryVersionSelectors.entrySet().forEach(entry -> {
            Closure versionSelector = (Closure)entry.getValue();
            this.libraryVersionSelectors.put((String)entry.getKey(), arg_0 -> ((Closure)versionSelector).call(arg_0));
        });
    }

    public Predicate<String> forLibrary(LibraryName library) {
        String libraryName = NameFormatter.format(library);
        return this.libraryVersionSelectors.containsKey(libraryName) ? this.libraryVersionSelectors.get(libraryName) : NO_VERSION_SELECTOR;
    }

    public int count() {
        return this.libraryVersionSelectors.size();
    }
}

