/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.dsl;

import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependency;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependencyFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

class ResolvedArtifactDependency
implements ArtifactDependency {
    private final Configuration configuration;
    private final ResolvedComponentResult component;
    private final ModuleComponentSelector selector;

    ResolvedArtifactDependency(Configuration configuration, ResolvedDependencyResult dependency, ModuleComponentSelector selector) {
        this.configuration = configuration;
        this.component = dependency.getSelected();
        this.selector = selector;
    }

    @Override
    public LibraryName getRequestedLibraryName() {
        return new LibraryName(this.selector.getGroup(), this.selector.getModule());
    }

    @Override
    public String getRequestedVersion() {
        return this.selector.getVersion();
    }

    @Override
    public LibraryName getSelectedLibraryName() {
        return new LibraryName(this.component.getModuleVersion().getGroup(), this.component.getModuleVersion().getName());
    }

    @Override
    public String getSelectedVersion() {
        return this.component.getModuleVersion().getVersion();
    }

    @Override
    public List<ArtifactDependency> getDependencies() {
        return this.component.getDependencies().stream().map(dependency -> ArtifactDependencyFactory.create(this.configuration, dependency)).filter(dependency -> dependency != null).collect(Collectors.toList());
    }
}

